/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml;

import java.io.InputStream;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.OrderedProperties;
import org.apache.camel.util.StringHelper;

public class IntegrationConfigurationPropertiesSource
implements PropertiesSource,
CamelContextAware {
    private final String name;
    private final Properties properties = new OrderedProperties();
    private CamelContext camelContext;

    public IntegrationConfigurationPropertiesSource(String name) {
        this.name = name;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getName() {
        return this.name;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public void parseConfigurationValue(String line) {
        if (line.contains("=")) {
            String key = StringHelper.before((String)line, (String)"=").trim();
            String value = StringHelper.after((String)line, (String)"=").trim();
            this.setProperty(key, value);
        } else if (ResourceHelper.hasScheme((String)line)) {
            try (InputStream is = ResourceHelper.resolveResourceAsInputStream((CamelContext)this.camelContext, (String)line);){
                Properties prop = new Properties();
                prop.load(is);
                for (String k : prop.stringPropertyNames()) {
                    String v = prop.getProperty(k);
                    String key = k.trim();
                    String value = v.trim();
                    this.setProperty(key, value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
        if (!this.camelContext.isStarted()) {
            this.camelContext.getPropertiesComponent().addInitialProperty(key, value);
        }
    }

    public String toString() {
        return "camel-yaml-dsl";
    }
}

