/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.NoErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.apache.camel.dsl.yaml.IntegrationConfigurationPropertiesSource;
import org.apache.camel.dsl.yaml.IntegrationSourceResource;
import org.apache.camel.dsl.yaml.YamlRoutesBuilderLoaderSupport;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.deserializers.OutputAwareFromDefinition;
import org.apache.camel.model.KameletDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.TemplatedRouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.DependencyStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.api.YamlUnicodeReader;
import org.snakeyaml.engine.v2.composer.Composer;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.NodeType;
import org.snakeyaml.engine.v2.nodes.SequenceNode;
import org.snakeyaml.engine.v2.parser.Parser;
import org.snakeyaml.engine.v2.parser.ParserImpl;
import org.snakeyaml.engine.v2.scanner.StreamReader;

@ManagedResource(description="Managed YAML RoutesBuilderLoader")
@RoutesLoader(value="yaml")
public class YamlRoutesBuilderLoader
extends YamlRoutesBuilderLoaderSupport {
    public static final String EXTENSION = "yaml";
    private static final Logger LOG = LoggerFactory.getLogger(YamlRoutesBuilderLoader.class);
    private static final String INTEGRATION_VERSION = "camel.apache.org/v1";
    private static final String BINDING_VERSION = "camel.apache.org/v1";
    private static final String STRIMZI_VERSION = "kafka.strimzi.io/v1";
    private static final String KNATIVE_VERSION = "messaging.knative.dev/v1";

    public YamlRoutesBuilderLoader() {
        super(EXTENSION);
    }

    @Override
    protected RouteBuilder builder(final Node root, final Resource resource) {
        final HashSet indexes = new HashSet();
        return new RouteConfigurationBuilder(){

            public void configure() throws Exception {
                YamlDeserializationContext ctx = YamlRoutesBuilderLoader.this.getDeserializationContext();
                ctx.setResource(resource);
                YamlDeserializerSupport.setDeserializationContext((Node)root, (YamlDeserializationContext)ctx);
                Object target = YamlRoutesBuilderLoader.this.preConfigureNode(root, ctx, false);
                if (target == null) {
                    return;
                }
                Iterator it = ObjectHelper.createIterator((Object)target);
                while (it.hasNext()) {
                    target = it.next();
                    if (target instanceof Node) {
                        SequenceNode seq = YamlDeserializerSupport.asSequenceNode((Node)((Node)target));
                        for (Node node : seq.getValue()) {
                            Object item;
                            boolean accepted;
                            int idx = -1;
                            if (node.getStartMark().isPresent()) {
                                idx = ((Mark)node.getStartMark().get()).getIndex();
                            }
                            if (idx != -1 && indexes.contains(idx) || !(accepted = this.doConfigure(item = ctx.mandatoryResolve(node).construct(node))) || idx == -1) continue;
                            indexes.add(idx);
                        }
                        continue;
                    }
                    this.doConfigure(target);
                }
            }

            private boolean doConfigure(Object item) throws Exception {
                if (item instanceof OutputAwareFromDefinition) {
                    RouteDefinition route = new RouteDefinition();
                    route.setInput(((OutputAwareFromDefinition)item).getDelegate());
                    route.setOutputs(((OutputAwareFromDefinition)item).getOutputs());
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().route(route);
                    return true;
                }
                if (item instanceof RouteDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().route((RouteDefinition)item);
                    return true;
                }
                if (item instanceof CamelContextCustomizer) {
                    ((CamelContextCustomizer)item).configure(this.getCamelContext());
                    return true;
                }
                if (item instanceof OnExceptionDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("onException must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().getOnExceptions().add((OnExceptionDefinition)item);
                    return true;
                }
                if (item instanceof ErrorHandlerBuilder) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("errorHandler must be defined before any routes in the RouteBuilder");
                    }
                    this.errorHandler((ErrorHandlerBuilder)item);
                    return true;
                }
                if (item instanceof RouteTemplateDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getRouteTemplateCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteTemplateCollection().routeTemplate((RouteTemplateDefinition)item);
                    return true;
                }
                if (item instanceof TemplatedRouteDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getTemplatedRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getTemplatedRouteCollection().templatedRoute((TemplatedRouteDefinition)item);
                    return true;
                }
                if (item instanceof RestDefinition) {
                    RestDefinition definition = (RestDefinition)item;
                    for (VerbDefinition verb : definition.getVerbs()) {
                        verb.setRest(definition);
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRestCollection(), (CamelContext)this.getCamelContext());
                    this.getRestCollection().rest(definition);
                    return true;
                }
                if (item instanceof RestConfigurationDefinition) {
                    ((RestConfigurationDefinition)item).asRestConfiguration(this.getCamelContext(), this.getCamelContext().getRestConfiguration());
                    return true;
                }
                return false;
            }

            public void configuration() throws Exception {
                YamlDeserializationContext ctx = YamlRoutesBuilderLoader.this.getDeserializationContext();
                ctx.setResource(resource);
                YamlDeserializerSupport.setDeserializationContext((Node)root, (YamlDeserializationContext)ctx);
                Object target = YamlRoutesBuilderLoader.this.preConfigureNode(root, ctx, false);
                if (target == null) {
                    return;
                }
                Iterator it = ObjectHelper.createIterator((Object)target);
                while (it.hasNext()) {
                    target = it.next();
                    if (target instanceof Node) {
                        SequenceNode seq = YamlDeserializerSupport.asSequenceNode((Node)((Node)target));
                        for (Node node : seq.getValue()) {
                            Object item;
                            boolean accepted;
                            int idx = -1;
                            if (node.getStartMark().isPresent()) {
                                idx = ((Mark)node.getStartMark().get()).getIndex();
                            }
                            if (idx != -1 && indexes.contains(idx) || !(accepted = this.doConfiguration(item = ctx.mandatoryResolve(node).construct(node))) || idx == -1) continue;
                            indexes.add(idx);
                        }
                        continue;
                    }
                    this.doConfiguration(target);
                }
            }

            private boolean doConfiguration(Object item) {
                if (item instanceof RouteConfigurationDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getRouteConfigurationCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteConfigurationCollection().routeConfiguration((RouteConfigurationDefinition)item);
                    return true;
                }
                return false;
            }
        };
    }

    private Object preConfigureNode(Node root, YamlDeserializationContext ctx, boolean preParse) throws Exception {
        Object target = root;
        if (Objects.equals(root.getNodeType(), NodeType.MAPPING)) {
            boolean binding;
            MappingNode mn = YamlDeserializerSupport.asMappingNode((Node)root);
            boolean integration = this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith("camel.apache.org/v1")) && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "Integration");
            boolean bl = binding = this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith("camel.apache.org/v1")) && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "KameletBinding");
            if (integration) {
                target = this.preConfigureIntegration(root, ctx, target, preParse);
            } else if (binding && !preParse) {
                target = this.preConfigureKameletBinding(root, ctx, target);
            }
        }
        return target;
    }

    private Object preConfigureIntegration(Node root, YamlDeserializationContext ctx, Object target, boolean preParse) {
        List<CamelContextCustomizer> list;
        Node configuration;
        ArrayList<Object> answer = new ArrayList<Object>();
        Node deps = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/dependencies");
        if (deps != null) {
            CamelContextCustomizer dep = this.preConfigureDependencies(deps);
            answer.add(dep);
        }
        if ((configuration = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/configuration")) != null) {
            list = this.preConfigureConfiguration(configuration);
            answer.addAll(list);
        }
        if ((configuration = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/traits/camel")) != null) {
            list = this.preConfigureTraitConfiguration(configuration);
            answer.addAll(list);
        }
        if ((configuration = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/traits/environment")) != null) {
            list = this.preConfigureTraitEnvironment(configuration);
            answer.addAll(list);
        }
        if (!preParse) {
            Node routes;
            Node sources = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/sources");
            if (sources != null) {
                List<CamelContextCustomizer> list2 = this.preConfigureSources(sources);
                answer.addAll(list2);
            }
            if ((routes = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/flows")) == null) {
                routes = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/flow");
            }
            if (routes != null) {
                answer.add(routes);
            }
        }
        return answer;
    }

    private CamelContextCustomizer preConfigureDependencies(Node node) {
        final List dep = YamlDeserializerSupport.asStringList((Node)node);
        return new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                for (DependencyStrategy ds : camelContext.getRegistry().findByType(DependencyStrategy.class)) {
                    for (String d : dep) {
                        try {
                            ds.onDependency(d);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        };
    }

    private List<CamelContextCustomizer> preConfigureConfiguration(Node node) {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        final ArrayList<String> lines = new ArrayList<String>();
        SequenceNode seq = YamlDeserializerSupport.asSequenceNode((Node)node);
        for (Node n : seq.getValue()) {
            MappingNode content = YamlDeserializerSupport.asMappingNode((Node)n);
            Map params = YamlDeserializerSupport.asMap((Node)content);
            Object type = params.get("type");
            Object value = params.get("value");
            if (!"property".equals(type) || value == null) continue;
            String line = value.toString();
            lines.add(line);
        }
        answer.add(new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                try {
                    PropertiesComponent pc = camelContext.getPropertiesComponent();
                    IntegrationConfigurationPropertiesSource ps = (IntegrationConfigurationPropertiesSource)pc.getPropertiesSource("integration-configuration");
                    if (ps == null) {
                        ps = new IntegrationConfigurationPropertiesSource("integration-configuration");
                        pc.addPropertiesSource((PropertiesSource)ps);
                    }
                    lines.forEach(ps::parseConfigurationValue);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Error adding properties from spec/configuration", (Throwable)e);
                }
            }
        });
        return answer;
    }

    private List<CamelContextCustomizer> preConfigureTraitConfiguration(Node node) {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        Node target = YamlDeserializerSupport.nodeAt((Node)node, (String)"configuration/properties/");
        final List lines = YamlDeserializerSupport.asStringList((Node)target);
        if (lines == null || lines.isEmpty()) {
            return answer;
        }
        answer.add(new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                try {
                    PropertiesComponent pc = camelContext.getPropertiesComponent();
                    IntegrationConfigurationPropertiesSource ps = (IntegrationConfigurationPropertiesSource)pc.getPropertiesSource("integration-trait-configuration");
                    if (ps == null) {
                        ps = new IntegrationConfigurationPropertiesSource("integration-trait-configuration");
                        pc.addPropertiesSource((PropertiesSource)ps);
                    }
                    lines.forEach(ps::parseConfigurationValue);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Error adding properties from spec/traits/camel/configuration", (Throwable)e);
                }
            }
        });
        return answer;
    }

    private List<CamelContextCustomizer> preConfigureTraitEnvironment(Node node) {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        Node target = YamlDeserializerSupport.nodeAt((Node)node, (String)"configuration/vars/");
        final List lines = YamlDeserializerSupport.asStringList((Node)target);
        if (lines == null || lines.isEmpty()) {
            return answer;
        }
        answer.add(new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                try {
                    PropertiesComponent pc = camelContext.getPropertiesComponent();
                    IntegrationConfigurationPropertiesSource ps = (IntegrationConfigurationPropertiesSource)pc.getPropertiesSource("environment-trait-configuration");
                    if (ps == null) {
                        ps = new IntegrationConfigurationPropertiesSource("environment-trait-configuration");
                        pc.addPropertiesSource((PropertiesSource)ps);
                    }
                    lines.forEach(ps::parseConfigurationValue);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Error adding properties from spec/traits/environment/configuration", (Throwable)e);
                }
            }
        });
        return answer;
    }

    private List<CamelContextCustomizer> preConfigureSources(Node node) {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        SequenceNode seq = YamlDeserializerSupport.asSequenceNode((Node)node);
        for (Node n : seq.getValue()) {
            MappingNode content = YamlDeserializerSupport.asMappingNode((Node)n);
            Map params = YamlDeserializerSupport.asMap((Node)content);
            Object name = params.get("name");
            Object code = params.get("content");
            if (name == null || code == null) continue;
            String ext = FileUtil.onlyExt((String)name.toString(), (boolean)false);
            IntegrationSourceResource res = new IntegrationSourceResource(ext, name.toString(), code.toString());
            answer.add(new CamelContextCustomizer((Resource)res){
                final /* synthetic */ Resource val$res;
                {
                    this.val$res = resource;
                }

                public void configure(CamelContext camelContext) {
                    try {
                        ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getRoutesLoader().loadRoutes(new Resource[]{this.val$res});
                    }
                    catch (Exception e) {
                        throw new RuntimeCamelException("Error loading sources from resource: " + this.val$res + " due to " + e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        return answer;
    }

    private Object preConfigureKameletBinding(Node root, YamlDeserializationContext ctx, Object target) throws Exception {
        RouteDefinition route = new RouteDefinition();
        String routeId = YamlDeserializerSupport.asText((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/metadata/name"));
        if (routeId != null) {
            route.routeId(routeId);
        }
        MappingNode source = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/source"));
        MappingNode sink = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/sink"));
        if (source != null && sink != null) {
            MappingNode errorHandler;
            Node steps;
            int line = -1;
            if (source.getStartMark().isPresent()) {
                line = ((Mark)source.getStartMark().get()).getLine();
            }
            String uri = this.extractCamelEndpointUri(source);
            route.from(uri);
            if (line != -1) {
                route.getInput().setLineNumber(line);
                if (ctx != null) {
                    route.getInput().setLocation(ctx.getResource().getLocation());
                }
            }
            if ((steps = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/steps")) != null) {
                SequenceNode sn = YamlDeserializerSupport.asSequenceNode((Node)steps);
                for (Node node : sn.getValue()) {
                    ToDefinition out;
                    boolean kamelet;
                    MappingNode step = YamlDeserializerSupport.asMappingNode((Node)node);
                    uri = this.extractCamelEndpointUri(step);
                    if (uri == null) continue;
                    line = -1;
                    if (node.getStartMark().isPresent()) {
                        line = ((Mark)node.getStartMark().get()).getLine();
                    }
                    if (kamelet = uri.startsWith("kamelet:")) {
                        uri = uri.substring(8);
                        out = new KameletDefinition(uri);
                    } else {
                        out = new ToDefinition(uri);
                    }
                    route.addOutput((ProcessorDefinition)out);
                    if (line == -1) continue;
                    out.setLineNumber(line);
                    if (ctx == null) continue;
                    out.setLocation(ctx.getResource().getLocation());
                }
            }
            line = -1;
            if (sink.getStartMark().isPresent()) {
                line = ((Mark)sink.getStartMark().get()).getLine();
            }
            uri = this.extractCamelEndpointUri(sink);
            ToDefinition to = new ToDefinition(uri);
            route.addOutput((ProcessorDefinition)to);
            if (line != -1) {
                to.setLineNumber(line);
                if (ctx != null) {
                    to.setLocation(ctx.getResource().getLocation());
                }
            }
            if ((errorHandler = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/errorHandler"))) != null) {
                NodeTuple nt = (NodeTuple)errorHandler.getValue().get(0);
                String ehName = YamlDeserializerSupport.asText((Node)nt.getKeyNode());
                DefaultErrorHandlerBuilder ehb = null;
                if ("sink".equals(ehName)) {
                    DeadLetterChannelBuilder dlch = new DeadLetterChannelBuilder();
                    MappingNode endpoint = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)nt.getValueNode(), (String)"/endpoint"));
                    String dlq = this.extractCamelEndpointUri(endpoint);
                    dlch.setDeadLetterUri(dlq);
                    ehb = dlch;
                } else if ("log".equals(ehName)) {
                    ehb = new DefaultErrorHandlerBuilder();
                } else if ("none".equals(ehName)) {
                    route.errorHandler((ErrorHandlerFactory)new NoErrorHandlerBuilder());
                }
                if (ehb != null) {
                    MappingNode prop = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)nt.getValueNode(), (String)"/parameters"));
                    Map params = YamlDeserializerSupport.asMap((Node)prop);
                    if (params != null) {
                        PropertyBindingSupport.build().withIgnoreCase(true).withFluentBuilder(true).withRemoveParameters(true).withCamelContext(this.getCamelContext()).withTarget((Object)ehb).withProperties(params).bind();
                    }
                    route.errorHandler((ErrorHandlerFactory)ehb);
                }
            }
            target = route;
        }
        return target;
    }

    private String extractCamelEndpointUri(MappingNode node) throws Exception {
        MappingNode mn = null;
        Node ref = YamlDeserializerSupport.nodeAt((Node)node, (String)"/ref");
        if (ref != null) {
            mn = YamlDeserializerSupport.asMappingNode((Node)ref);
        }
        boolean kamelet = mn != null && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "Kamelet");
        boolean strimzi = !kamelet && mn != null && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith(STRIMZI_VERSION)) && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "KafkaTopic");
        boolean knative = !kamelet && !strimzi && mn != null && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith(KNATIVE_VERSION));
        Object uri = kamelet || strimzi || knative ? this.extractTupleValue(mn.getValue(), "name") : this.extractTupleValue(node.getValue(), "uri");
        MappingNode prop = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)node, (String)"/properties"));
        Map params = YamlDeserializerSupport.asMap((Node)prop);
        if (params != null && !params.isEmpty()) {
            String query = URISupport.createQueryString((Map)params);
            uri = (String)uri + "?" + query;
        }
        if (kamelet) {
            return "kamelet:" + (String)uri;
        }
        if (strimzi) {
            return "kafka:" + (String)uri;
        }
        if (knative) {
            return "knative:channel/" + (String)uri;
        }
        return uri;
    }

    public void preParseRoute(Resource resource) throws Exception {
        LOG.trace("Pre-parsing: {}", (Object)resource.getLocation());
        if (!resource.exists()) {
            throw new FileNotFoundException("Resource not found: " + resource.getLocation());
        }
        try (InputStream is = resource.getInputStream();){
            StreamReader reader = new StreamReader(this.settings, (Reader)new YamlUnicodeReader(is));
            ParserImpl parser = new ParserImpl(this.settings, reader);
            Composer composer = new Composer(this.settings, (Parser)parser);
            composer.getSingleNode().map(node -> this.preParseNode((Node)node, resource));
        }
    }

    private Object preParseNode(Node root, Resource resource) {
        LOG.trace("Pre-parsing node: {}", (Object)root);
        YamlDeserializationContext ctx = this.getDeserializationContext();
        ctx.setResource(resource);
        YamlDeserializerSupport.setDeserializationContext((Node)root, (YamlDeserializationContext)ctx);
        try {
            Object target = this.preConfigureNode(root, ctx, true);
            Iterator it = ObjectHelper.createIterator((Object)target);
            while (it.hasNext()) {
                target = it.next();
                if (!(target instanceof CamelContextCustomizer)) continue;
                CamelContextCustomizer customizer = (CamelContextCustomizer)target;
                customizer.configure(this.getCamelContext());
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Error pre-parsing resource: " + resource.getLocation(), (Throwable)e);
        }
        return null;
    }
}

