/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml;

import java.io.InputStream;
import java.util.List;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.StartupStep;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerResolver;
import org.apache.camel.dsl.yaml.deserializers.CustomResolver;
import org.apache.camel.dsl.yaml.deserializers.EndpointProducerDeserializersResolver;
import org.apache.camel.dsl.yaml.deserializers.ModelDeserializersResolver;
import org.apache.camel.dsl.yaml.deserializers.model.OutputAwareFromDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.support.RoutesBuilderLoaderSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.constructor.BaseConstructor;

@ManagedResource(description="Managed YAML RoutesBuilderLoader")
@RoutesLoader(value="yaml")
public class YamlRoutesBuilderLoader
extends RoutesBuilderLoaderSupport {
    public static final String EXTENSION = "yaml";
    private LoadSettings settings;
    private YamlDeserializationContext constructor;
    private StartupStepRecorder recorder;

    @ManagedAttribute(description="Supported file extension")
    public String getSupportedExtension() {
        return EXTENSION;
    }

    protected void doBuild() throws Exception {
        super.doBuild();
        this.recorder = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getStartupStepRecorder();
        this.settings = LoadSettings.builder().build();
        this.constructor = new YamlDeserializationContext(this.settings);
        this.constructor.setCamelContext(this.getCamelContext());
        this.constructor.addResolvers(new YamlDeserializerResolver[]{new CustomResolver()});
        this.constructor.addResolvers(new YamlDeserializerResolver[]{new ModelDeserializersResolver()});
        this.constructor.addResolvers(new YamlDeserializerResolver[]{new EndpointProducerDeserializersResolver()});
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Object)this.constructor);
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)this.constructor);
        this.constructor = null;
        this.settings = null;
    }

    public RoutesBuilder loadRoutesBuilder(final Resource resource) throws Exception {
        ObjectHelper.notNull((Object)this.constructor, (String)"constructor");
        ObjectHelper.notNull((Object)this.settings, (String)"settings");
        return new RouteBuilder(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void configure() throws Exception {
                Load load = new Load(YamlRoutesBuilderLoader.this.settings, (BaseConstructor)YamlRoutesBuilderLoader.this.constructor);
                StartupStep step = YamlRoutesBuilderLoader.this.recorder != null ? YamlRoutesBuilderLoader.this.recorder.beginStep(YamlRoutesBuilderLoader.class, resource.getLocation(), "Loading and Parsing YAML routes") : null;
                try (InputStream is = resource.getInputStream();){
                    for (Object item : (List)load.loadFromInputStream(is)) {
                        this.configure(item);
                    }
                }
                finally {
                    if (YamlRoutesBuilderLoader.this.recorder != null) {
                        YamlRoutesBuilderLoader.this.recorder.endStep(step);
                    }
                }
            }

            private void configure(Object item) {
                if (item instanceof OutputAwareFromDefinition) {
                    RouteDefinition route = new RouteDefinition();
                    route.setInput(((OutputAwareFromDefinition)item).getDelegate());
                    route.setOutputs(((OutputAwareFromDefinition)item).getOutputs());
                    this.getRouteCollection().route(route);
                } else if (item instanceof RouteDefinition) {
                    this.getRouteCollection().route((RouteDefinition)item);
                } else if (item instanceof RestDefinition) {
                    RestDefinition definition = (RestDefinition)item;
                    for (VerbDefinition verb : definition.getVerbs()) {
                        verb.setRest(definition);
                    }
                    this.getRestCollection().rest(definition);
                } else if (item instanceof CamelContextCustomizer) {
                    ((CamelContextCustomizer)item).configure(YamlRoutesBuilderLoader.this.getCamelContext());
                } else if (item instanceof OnExceptionDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("onException must be defined before any routes in the RouteBuilder");
                    }
                    this.getRouteCollection().getOnExceptions().add((OnExceptionDefinition)item);
                } else if (item instanceof ErrorHandlerBuilder) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("errorHandler must be defined before any routes in the RouteBuilder");
                    }
                    this.errorHandler((ErrorHandlerBuilder)item);
                }
            }
        };
    }
}

