/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml;

import java.io.InputStream;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Ordered;
import org.apache.camel.component.properties.AbstractLocationPropertiesSource;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.StringHelper;

public class IntegrationConfigurationPropertiesSource
extends AbstractLocationPropertiesSource
implements CamelContextAware,
Ordered {
    private final String name;
    private CamelContext camelContext;

    public IntegrationConfigurationPropertiesSource(PropertiesComponent propertiesComponent, PropertiesLocation location, String name) {
        super(propertiesComponent, location);
        this.name = name;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getName() {
        return this.name;
    }

    public Properties loadPropertiesFromLocation(PropertiesComponent propertiesComponent, PropertiesLocation location) {
        return null;
    }

    public int getOrder() {
        return 300;
    }

    public void parseConfigurationValue(String line) {
        if (line.contains("=")) {
            String key = StringHelper.before((String)line, (String)"=").trim();
            String value = StringHelper.after((String)line, (String)"=").trim();
            this.setProperty(key, value);
        } else if (ResourceHelper.hasScheme((String)line)) {
            try (InputStream is = ResourceHelper.resolveResourceAsInputStream((CamelContext)this.camelContext, (String)line);){
                Properties prop = new Properties();
                prop.load(is);
                for (String k : prop.stringPropertyNames()) {
                    String v = prop.getProperty(k);
                    String key = k.trim();
                    String value = v.trim();
                    this.setProperty(key, value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "camel-yaml-dsl";
    }
}

