/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.dsl.yaml.IntegrationConfigurationPropertiesSource;
import org.apache.camel.dsl.yaml.IntegrationSourceResource;
import org.apache.camel.dsl.yaml.YamlRoutesBuilderLoaderSupport;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.common.exception.InvalidNodeTypeException;
import org.apache.camel.dsl.yaml.deserializers.OutputAwareFromDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.KameletDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.TemplatedRouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.errorhandler.DeadLetterChannelDefinition;
import org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.NoErrorHandlerDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DependencyStrategy;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringQuoteHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.api.YamlUnicodeReader;
import org.snakeyaml.engine.v2.composer.Composer;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.NodeType;
import org.snakeyaml.engine.v2.nodes.SequenceNode;
import org.snakeyaml.engine.v2.parser.Parser;
import org.snakeyaml.engine.v2.parser.ParserImpl;
import org.snakeyaml.engine.v2.scanner.StreamReader;

@ManagedResource(description="Managed YAML RoutesBuilderLoader")
@RoutesLoader(value="yaml")
public class YamlRoutesBuilderLoader
extends YamlRoutesBuilderLoaderSupport {
    public static final String EXTENSION = "yaml";
    public static final String[] SUPPORTED_EXTENSION = new String[]{"yaml", "camel.yaml", "pipe.yaml"};
    private static final String DEPRECATED_EXTENSION = "camelk.yaml";
    private static final Logger LOG = LoggerFactory.getLogger(YamlRoutesBuilderLoader.class);
    private final AtomicBoolean deprecatedWarnLogged = new AtomicBoolean();
    private final AtomicBoolean deprecatedBindingWarnLogged = new AtomicBoolean();
    private static final String INTEGRATION_VERSION = "camel.apache.org/v1";
    @Deprecated
    private static final String BINDING_VERSION = "camel.apache.org/v1alpha1";
    private static final String PIPE_VERSION = "camel.apache.org/v1";
    private static final String STRIMZI_VERSION = "kafka.strimzi.io/v1beta2";
    private static final String KNATIVE_MESSAGING_VERSION = "messaging.knative.dev/v1";
    private static final String KNATIVE_EVENTING_VERSION = "eventing.knative.dev/v1";
    private static final String KNATIVE_EVENT_TYPE = "org.apache.camel.event";
    private final Map<String, Boolean> preparseDone = new ConcurrentHashMap<String, Boolean>();

    public YamlRoutesBuilderLoader() {
        super(EXTENSION);
    }

    YamlRoutesBuilderLoader(String extension) {
        super(extension);
    }

    public boolean isSupportedExtension(String extension) {
        if (DEPRECATED_EXTENSION.equals(extension)) {
            if (this.deprecatedWarnLogged.compareAndSet(false, true)) {
                LOG.warn("File extension camelk.yaml is deprecated. Use camel.yaml instead.");
            }
            return true;
        }
        return Arrays.asList(SUPPORTED_EXTENSION).contains(extension);
    }

    @Override
    protected RouteBuilder builder(final YamlDeserializationContext ctx, final Node root) {
        final HashSet indexes = new HashSet();
        return new RouteConfigurationBuilder(){

            public void configure() throws Exception {
                YamlDeserializerSupport.setDeserializationContext((Node)root, (YamlDeserializationContext)ctx);
                Object target = YamlRoutesBuilderLoader.this.preConfigureNode(root, ctx, false);
                if (target == null) {
                    return;
                }
                Iterator it = ObjectHelper.createIterator((Object)target);
                while (it.hasNext()) {
                    target = it.next();
                    if (target instanceof Node && YamlDeserializerSupport.isSequenceNode((Node)((Node)target))) {
                        SequenceNode seq = YamlDeserializerSupport.asSequenceNode((Node)((Node)target));
                        for (Node node : seq.getValue()) {
                            Object item;
                            boolean accepted;
                            int idx = -1;
                            if (node.getStartMark().isPresent()) {
                                idx = ((Mark)node.getStartMark().get()).getIndex();
                            }
                            if (idx != -1 && indexes.contains(idx) || !(accepted = this.doConfigure(item = ctx.mandatoryResolve(node).construct(node))) || idx == -1) continue;
                            indexes.add(idx);
                        }
                        continue;
                    }
                    this.doConfigure(target);
                }
                Resource resource = ctx.getResource();
                if (resource != null) {
                    YamlRoutesBuilderLoader.this.preparseDone.remove(resource.getLocation());
                }
                YamlRoutesBuilderLoader.this.beansDeserializer.clearCache();
            }

            private boolean doConfigure(Object item) throws Exception {
                if (item instanceof OutputAwareFromDefinition) {
                    RouteDefinition route = new RouteDefinition();
                    route.setInput(((OutputAwareFromDefinition)item).getDelegate());
                    route.setOutputs(((OutputAwareFromDefinition)item).getOutputs());
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().route(route);
                    return true;
                }
                if (item instanceof RouteDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().route((RouteDefinition)item);
                    return true;
                }
                if (item instanceof CamelContextCustomizer) {
                    ((CamelContextCustomizer)item).configure(this.getCamelContext());
                    return true;
                }
                if (item instanceof InterceptFromDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("interceptFrom must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().getInterceptFroms().add((InterceptFromDefinition)item);
                    return true;
                }
                if (item instanceof InterceptDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("intercept must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().getIntercepts().add((InterceptDefinition)item);
                    return true;
                }
                if (item instanceof InterceptSendToEndpointDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("interceptSendToEndpoint must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().getInterceptSendTos().add((InterceptSendToEndpointDefinition)item);
                    return true;
                }
                if (item instanceof OnCompletionDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("onCompletion must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().getOnCompletions().add((OnCompletionDefinition)item);
                    return true;
                }
                if (item instanceof OnExceptionDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("onException must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().getOnExceptions().add((OnExceptionDefinition)item);
                    return true;
                }
                if (item instanceof ErrorHandlerFactory) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("errorHandler must be defined before any routes in the RouteBuilder");
                    }
                    this.errorHandler((ErrorHandlerFactory)item);
                    return true;
                }
                if (item instanceof RouteTemplateDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getRouteTemplateCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteTemplateCollection().routeTemplate((RouteTemplateDefinition)item);
                    return true;
                }
                if (item instanceof TemplatedRouteDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getTemplatedRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getTemplatedRouteCollection().templatedRoute((TemplatedRouteDefinition)item);
                    return true;
                }
                if (item instanceof RestDefinition) {
                    RestDefinition definition = (RestDefinition)item;
                    for (VerbDefinition verb : definition.getVerbs()) {
                        verb.setRest(definition);
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRestCollection(), (CamelContext)this.getCamelContext());
                    this.getRestCollection().rest(definition);
                    return true;
                }
                if (item instanceof RestConfigurationDefinition) {
                    ((RestConfigurationDefinition)item).asRestConfiguration(this.getCamelContext(), this.getCamelContext().getRestConfiguration());
                    return true;
                }
                return false;
            }

            public void configuration() throws Exception {
                YamlDeserializerSupport.setDeserializationContext((Node)root, (YamlDeserializationContext)ctx);
                Object target = YamlRoutesBuilderLoader.this.preConfigureNode(root, ctx, false);
                if (target == null) {
                    return;
                }
                Iterator it = ObjectHelper.createIterator((Object)target);
                while (it.hasNext()) {
                    target = it.next();
                    if (target instanceof Node && YamlDeserializerSupport.isSequenceNode((Node)((Node)target))) {
                        SequenceNode seq = YamlDeserializerSupport.asSequenceNode((Node)((Node)target));
                        for (Node node : seq.getValue()) {
                            int idx = -1;
                            if (node.getStartMark().isPresent()) {
                                idx = ((Mark)node.getStartMark().get()).getIndex();
                            }
                            if (idx != -1 && indexes.contains(idx) || node.getNodeType() != NodeType.MAPPING) continue;
                            MappingNode mn = YamlDeserializerSupport.asMappingNode((Node)node);
                            for (NodeTuple nt : mn.getValue()) {
                                Object item;
                                boolean accepted;
                                String key = YamlDeserializerSupport.asText((Node)nt.getKeyNode());
                                if (!"route-configuration".equals(key) && !"routeConfiguration".equals(key) || !(accepted = this.doConfiguration(item = ctx.mandatoryResolve(node).construct(node))) || idx == -1) continue;
                                indexes.add(idx);
                            }
                        }
                        continue;
                    }
                    this.doConfiguration(target);
                }
            }

            private boolean doConfiguration(Object item) {
                if (item instanceof RouteConfigurationDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getRouteConfigurationCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteConfigurationCollection().routeConfiguration((RouteConfigurationDefinition)item);
                    return true;
                }
                return false;
            }
        };
    }

    private Object preConfigureNode(Node root, YamlDeserializationContext ctx, boolean preParse) {
        Object target = root;
        if (Objects.equals(root.getNodeType(), NodeType.MAPPING)) {
            boolean pipe;
            MappingNode mn = YamlDeserializerSupport.asMappingNode((Node)root);
            boolean integration = this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith("camel.apache.org/v1")) && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "Integration");
            boolean binding = this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith(BINDING_VERSION)) && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "KameletBinding");
            boolean bl = pipe = this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith("camel.apache.org/v1")) && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "Pipe");
            if (integration) {
                target = this.preConfigureIntegration(root, ctx, target, preParse);
            } else if (binding || pipe) {
                if (binding && this.deprecatedBindingWarnLogged.compareAndSet(false, true)) {
                    LOG.warn("CamelK kind=KameletBinding is deprecated. Use CamelK kind=Pipe instead.");
                }
                target = this.preConfigurePipe(root, ctx, target, preParse);
            }
        }
        if (preParse && Objects.equals(root.getNodeType(), NodeType.SEQUENCE)) {
            ArrayList<Object> list = new ArrayList<Object>();
            SequenceNode sn = YamlDeserializerSupport.asSequenceNode((Node)root);
            for (Node node : sn.getValue()) {
                if (!Objects.equals(node.getNodeType(), NodeType.MAPPING)) continue;
                MappingNode mn = YamlDeserializerSupport.asMappingNode((Node)node);
                for (NodeTuple nt : mn.getValue()) {
                    String key = YamlDeserializerSupport.asText((Node)nt.getKeyNode());
                    if (!"beans".equals(key)) continue;
                    Node beans = nt.getValueNode();
                    YamlDeserializerSupport.setDeserializationContext((Node)beans, (YamlDeserializationContext)ctx);
                    Object output = this.beansDeserializer.construct(beans);
                    if (output == null) continue;
                    list.add(output);
                }
            }
            if (!list.isEmpty()) {
                target = list;
            }
        }
        return target;
    }

    private Object preConfigureIntegration(Node root, YamlDeserializationContext ctx, Object target, boolean preParse) {
        Node spec = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec");
        if (spec != null) {
            return this.preConfigureIntegrationSpec(spec, ctx, target, preParse);
        }
        return new ArrayList();
    }

    private List<Object> preConfigureIntegrationSpec(Node root, YamlDeserializationContext ctx, Object target, boolean preParse) {
        List<CamelContextCustomizer> list;
        Node configuration;
        ArrayList<Object> answer = new ArrayList<Object>();
        Node deps = YamlDeserializerSupport.nodeAt((Node)root, (String)"/dependencies");
        if (deps != null) {
            CamelContextCustomizer dep = this.preConfigureDependencies(deps);
            answer.add(dep);
        }
        if ((configuration = YamlDeserializerSupport.nodeAt((Node)root, (String)"/configuration")) != null) {
            list = this.preConfigureConfiguration(ctx.getResource(), configuration);
            answer.addAll(list);
        }
        if ((configuration = YamlDeserializerSupport.nodeAt((Node)root, (String)"/traits/camel")) != null) {
            list = this.preConfigureTraitConfiguration(ctx.getResource(), configuration);
            answer.addAll(list);
        }
        if ((configuration = YamlDeserializerSupport.nodeAt((Node)root, (String)"/traits/environment")) != null) {
            list = this.preConfigureTraitEnvironment(ctx.getResource(), configuration);
            answer.addAll(list);
        }
        if (!preParse) {
            Node routes;
            Node sources = YamlDeserializerSupport.nodeAt((Node)root, (String)"/sources");
            if (sources != null) {
                List<CamelContextCustomizer> list2 = this.preConfigureSources(sources);
                answer.addAll(list2);
            }
            if ((routes = YamlDeserializerSupport.nodeAt((Node)root, (String)"/flows")) == null) {
                routes = YamlDeserializerSupport.nodeAt((Node)root, (String)"/flow");
            }
            if (routes != null) {
                if (routes.getNodeType() != NodeType.SEQUENCE) {
                    throw new InvalidNodeTypeException(routes, NodeType.SEQUENCE);
                }
                answer.add(routes);
            }
        }
        return answer;
    }

    private CamelContextCustomizer preConfigureDependencies(Node node) {
        final List dep = YamlDeserializerSupport.asStringList((Node)node);
        return new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                for (DependencyStrategy ds : camelContext.getRegistry().findByType(DependencyStrategy.class)) {
                    for (String d : dep) {
                        try {
                            ds.onDependency(d);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        };
    }

    private List<CamelContextCustomizer> preConfigureConfiguration(final Resource resource, Node node) {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        final ArrayList<String> lines = new ArrayList<String>();
        SequenceNode seq = YamlDeserializerSupport.asSequenceNode((Node)node);
        for (Node n : seq.getValue()) {
            MappingNode content = YamlDeserializerSupport.asMappingNode((Node)n);
            Map params = YamlDeserializerSupport.asMap((Node)content);
            Object type = params.get("type");
            Object value = params.get("value");
            if (!"property".equals(type) || value == null) continue;
            String line = value.toString();
            lines.add(line);
        }
        answer.add(new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                try {
                    PropertiesComponent pc = (PropertiesComponent)camelContext.getPropertiesComponent();
                    IntegrationConfigurationPropertiesSource ps = (IntegrationConfigurationPropertiesSource)pc.getPropertiesSource("integration-configuration");
                    if (ps == null) {
                        ps = new IntegrationConfigurationPropertiesSource(pc, new PropertiesLocation(resource.getLocation()), "integration-configuration");
                        pc.addPropertiesSource((PropertiesSource)ps);
                    }
                    lines.forEach(ps::parseConfigurationValue);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Error adding properties from spec/configuration", (Throwable)e);
                }
            }
        });
        return answer;
    }

    private List<CamelContextCustomizer> preConfigureTraitConfiguration(final Resource resource, Node node) {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        Node target = YamlDeserializerSupport.nodeAt((Node)node, (String)"configuration/properties/");
        final List lines = YamlDeserializerSupport.asStringList((Node)target);
        if (lines == null || lines.isEmpty()) {
            return answer;
        }
        answer.add(new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                try {
                    PropertiesComponent pc = (PropertiesComponent)camelContext.getPropertiesComponent();
                    IntegrationConfigurationPropertiesSource ps = (IntegrationConfigurationPropertiesSource)pc.getPropertiesSource("integration-trait-configuration");
                    if (ps == null) {
                        ps = new IntegrationConfigurationPropertiesSource(pc, new PropertiesLocation(resource.getLocation()), "integration-trait-configuration");
                        pc.addPropertiesSource((PropertiesSource)ps);
                    }
                    lines.forEach(ps::parseConfigurationValue);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Error adding properties from spec/traits/camel/configuration", (Throwable)e);
                }
            }
        });
        return answer;
    }

    private List<CamelContextCustomizer> preConfigureTraitEnvironment(final Resource resource, Node node) {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        Node target = YamlDeserializerSupport.nodeAt((Node)node, (String)"configuration/vars/");
        final List lines = YamlDeserializerSupport.asStringList((Node)target);
        if (lines == null || lines.isEmpty()) {
            return answer;
        }
        answer.add(new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                try {
                    PropertiesComponent pc = (PropertiesComponent)camelContext.getPropertiesComponent();
                    IntegrationConfigurationPropertiesSource ps = (IntegrationConfigurationPropertiesSource)pc.getPropertiesSource("environment-trait-configuration");
                    if (ps == null) {
                        ps = new IntegrationConfigurationPropertiesSource(pc, new PropertiesLocation(resource.getLocation()), "environment-trait-configuration");
                        pc.addPropertiesSource((PropertiesSource)ps);
                    }
                    lines.forEach(ps::parseConfigurationValue);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Error adding properties from spec/traits/environment/configuration", (Throwable)e);
                }
            }
        });
        return answer;
    }

    private List<CamelContextCustomizer> preConfigureTraitConfigurationBinding(final Resource resource, Map<String, Object> map) {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        if (map == null || map.isEmpty()) {
            return null;
        }
        Object value = map.get("trait.camel.apache.org/camel.properties");
        if (value == null || value.toString().isEmpty()) {
            return null;
        }
        final String[] properties = StringQuoteHelper.splitSafeQuote((String)value.toString(), (char)',', (boolean)true);
        answer.add(new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                try {
                    PropertiesComponent pc = (PropertiesComponent)camelContext.getPropertiesComponent();
                    IntegrationConfigurationPropertiesSource ps = (IntegrationConfigurationPropertiesSource)pc.getPropertiesSource("binding-trait-configuration");
                    if (ps == null) {
                        ps = new IntegrationConfigurationPropertiesSource(pc, new PropertiesLocation(resource.getLocation()), "binding-trait-configuration");
                        pc.addPropertiesSource((PropertiesSource)ps);
                    }
                    for (String line : properties) {
                        ps.parseConfigurationValue(line);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Error adding properties from metadata/annotations/", (Throwable)e);
                }
            }
        });
        return answer;
    }

    private List<CamelContextCustomizer> preConfigureTraitEnvironmentBinding(final Resource resource, Map<String, Object> map) {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        if (map == null || map.isEmpty()) {
            return null;
        }
        Object value = map.get("trait.camel.apache.org/environment.vars");
        if (value == null || value.toString().isEmpty()) {
            return null;
        }
        final String[] properties = StringQuoteHelper.splitSafeQuote((String)value.toString(), (char)',', (boolean)true);
        answer.add(new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                try {
                    PropertiesComponent pc = (PropertiesComponent)camelContext.getPropertiesComponent();
                    IntegrationConfigurationPropertiesSource ps = (IntegrationConfigurationPropertiesSource)pc.getPropertiesSource("environment-trait-configuration");
                    if (ps == null) {
                        ps = new IntegrationConfigurationPropertiesSource(pc, new PropertiesLocation(resource.getLocation()), "environment-trait-configuration");
                        pc.addPropertiesSource((PropertiesSource)ps);
                    }
                    for (String line : properties) {
                        ps.parseConfigurationValue(line);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Error adding properties from metadata/annotations/", (Throwable)e);
                }
            }
        });
        return answer;
    }

    private List<CamelContextCustomizer> preConfigureSources(Node node) {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        SequenceNode seq = YamlDeserializerSupport.asSequenceNode((Node)node);
        for (Node n : seq.getValue()) {
            MappingNode content = YamlDeserializerSupport.asMappingNode((Node)n);
            Map params = YamlDeserializerSupport.asMap((Node)content);
            Object name = params.get("name");
            Object code = params.get("content");
            if (name == null || code == null) continue;
            String ext = FileUtil.onlyExt((String)name.toString(), (boolean)false);
            IntegrationSourceResource res = new IntegrationSourceResource(ext, name.toString(), code.toString());
            answer.add(new CamelContextCustomizer(){
                final /* synthetic */ Resource val$res;
                {
                    this.val$res = resource;
                }

                public void configure(CamelContext camelContext) {
                    try {
                        PluginHelper.getRoutesLoader((CamelContext)camelContext).loadRoutes(new Resource[]{this.val$res});
                    }
                    catch (Exception e) {
                        throw new RuntimeCamelException("Error loading sources from resource: " + String.valueOf(this.val$res) + " due to " + e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        return answer;
    }

    private Object preConfigurePipe(Node root, YamlDeserializationContext ctx, Object target, boolean preParse) {
        Node integration;
        ArrayList<Object> answer = new ArrayList<Object>();
        MappingNode ann = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/metadata/annotations"));
        Map params = YamlDeserializerSupport.asMap((Node)ann);
        if (params != null) {
            List<CamelContextCustomizer> list = this.preConfigureTraitConfigurationBinding(ctx.getResource(), params);
            if (list != null) {
                answer.addAll(list);
            }
            if ((list = this.preConfigureTraitEnvironmentBinding(ctx.getResource(), params)) != null) {
                answer.addAll(list);
            }
        }
        if ((integration = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/integration")) != null) {
            answer.addAll(this.preConfigureIntegrationSpec(integration, ctx, target, preParse));
        }
        if (!preParse) {
            RouteDefinition route = new RouteDefinition();
            String routeId = YamlDeserializerSupport.asText((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/metadata/name"));
            if (routeId != null) {
                route.routeId(routeId);
            }
            MappingNode source = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/source"));
            MappingNode sink = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/sink"));
            if (source != null) {
                MappingNode errorHandler;
                Node steps;
                MappingNode dataTypes;
                int line = -1;
                if (source.getStartMark().isPresent()) {
                    line = ((Mark)source.getStartMark().get()).getLine();
                }
                String uri = this.extractCamelEndpointUri(source);
                route.from(uri);
                if (line != -1) {
                    route.getInput().setLineNumber(line);
                    if (ctx != null) {
                        route.getInput().setLocation(ctx.getResource().getLocation());
                    }
                }
                if ((dataTypes = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)source, (String)"/dataTypes"))) != null) {
                    MappingNode out;
                    MappingNode in = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)dataTypes, (String)"/in"));
                    if (in != null) {
                        route.inputType(this.extractDataType(in));
                    }
                    if ((out = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)dataTypes, (String)"/out"))) != null) {
                        route.transform(new DataType(this.extractDataType(out)));
                    }
                }
                if ((steps = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/steps")) != null) {
                    SequenceNode sn = YamlDeserializerSupport.asSequenceNode((Node)steps);
                    for (Node node : sn.getValue()) {
                        ToDefinition out;
                        boolean kamelet;
                        MappingNode step = YamlDeserializerSupport.asMappingNode((Node)node);
                        uri = this.extractCamelEndpointUri(step);
                        if (uri == null) continue;
                        line = -1;
                        if (node.getStartMark().isPresent()) {
                            line = ((Mark)node.getStartMark().get()).getLine();
                        }
                        if (kamelet = uri.startsWith("kamelet:")) {
                            uri = uri.substring(8);
                            out = new KameletDefinition(uri);
                        } else {
                            out = new ToDefinition(uri);
                        }
                        route.addOutput((ProcessorDefinition)out);
                        if (line == -1) continue;
                        out.setLineNumber(line);
                        if (ctx == null) continue;
                        out.setLocation(ctx.getResource().getLocation());
                    }
                }
                if (sink != null) {
                    dataTypes = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)sink, (String)"/dataTypes"));
                    if (dataTypes != null) {
                        MappingNode out;
                        MappingNode in = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)dataTypes, (String)"/in"));
                        if (in != null) {
                            route.transform(new DataType(this.extractDataType(in)));
                        }
                        if ((out = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)dataTypes, (String)"/out"))) != null) {
                            route.outputType(this.extractDataType(out));
                        }
                    }
                    line = -1;
                    if (sink.getStartMark().isPresent()) {
                        line = ((Mark)sink.getStartMark().get()).getLine();
                    }
                    uri = this.extractCamelEndpointUri(sink);
                    ToDefinition to = new ToDefinition(uri);
                    route.addOutput((ProcessorDefinition)to);
                    if (line != -1) {
                        to.setLineNumber(line);
                        if (ctx != null) {
                            to.setLocation(ctx.getResource().getLocation());
                        }
                    }
                }
                if ((errorHandler = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/errorHandler"))) != null) {
                    NodeTuple nt = (NodeTuple)errorHandler.getValue().get(0);
                    String ehName = YamlDeserializerSupport.asText((Node)nt.getKeyNode());
                    DefaultErrorHandlerDefinition ehf = null;
                    if ("sink".equals(ehName)) {
                        DeadLetterChannelDefinition dlcd = new DeadLetterChannelDefinition();
                        MappingNode endpoint = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)nt.getValueNode(), (String)"/endpoint"));
                        String dlq = this.extractCamelEndpointUri(endpoint);
                        dlcd.setDeadLetterUri(dlq);
                        ehf = dlcd;
                    } else if ("log".equals(ehName)) {
                        ehf = new DefaultErrorHandlerDefinition();
                    } else if ("none".equals(ehName)) {
                        route.errorHandler((ErrorHandlerFactory)new NoErrorHandlerDefinition());
                    }
                    if (ehf != null) {
                        MappingNode prop = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)nt.getValueNode(), (String)"/parameters"));
                        params = YamlDeserializerSupport.asMap((Node)prop);
                        if (params != null) {
                            PropertyBindingSupport.build().withIgnoreCase(true).withFluentBuilder(true).withRemoveParameters(true).withCamelContext(this.getCamelContext()).withTarget((Object)ehf).withProperties(params).bind();
                        }
                        route.errorHandler((ErrorHandlerFactory)ehf);
                    }
                }
            }
            answer.add(route);
        }
        return answer;
    }

    private String extractDataType(MappingNode node) {
        String scheme = this.extractTupleValue(node.getValue(), "scheme");
        String format = this.extractTupleValue(node.getValue(), "format");
        if (scheme != null) {
            return scheme + ":" + format;
        }
        return format;
    }

    private String extractCamelEndpointUri(MappingNode node) {
        boolean knativeChannel;
        MappingNode mn = null;
        Node ref = YamlDeserializerSupport.nodeAt((Node)node, (String)"/ref");
        if (ref != null) {
            mn = YamlDeserializerSupport.asMappingNode((Node)ref);
        }
        boolean kamelet = mn != null && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "Kamelet");
        boolean strimzi = !kamelet && mn != null && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith(STRIMZI_VERSION)) && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "KafkaTopic");
        boolean knativeBroker = !kamelet && mn != null && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith(KNATIVE_EVENTING_VERSION)) && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "Broker");
        boolean bl = knativeChannel = !kamelet && !strimzi && mn != null && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith(KNATIVE_MESSAGING_VERSION));
        Object uri = knativeBroker ? KNATIVE_EVENT_TYPE : (kamelet || strimzi || knativeChannel ? this.extractTupleValue(mn.getValue(), "name") : this.extractTupleValue(node.getValue(), "uri"));
        MappingNode prop = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)node, (String)"/properties"));
        Map params = YamlDeserializerSupport.asMap((Node)prop);
        if (knativeBroker && params != null && params.containsKey("type")) {
            uri = params.remove("type").toString();
        }
        if (params != null && !params.isEmpty()) {
            String query = URISupport.createQueryString((Map)params);
            uri = (String)uri + "?" + query;
        }
        if (kamelet) {
            return "kamelet:" + (String)uri;
        }
        if (strimzi) {
            return "kafka:" + (String)uri;
        }
        if (knativeBroker) {
            uri = ((String)uri).contains("?") ? (String)uri + "&kind=Broker&name=" + this.extractTupleValue(mn.getValue(), "name") : (String)uri + "?kind=Broker&name=" + this.extractTupleValue(mn.getValue(), "name");
            return "knative:event/" + (String)uri;
        }
        if (knativeChannel) {
            return "knative:channel/" + (String)uri;
        }
        return uri;
    }

    public void preParseRoute(Resource resource) throws Exception {
        if (this.preparseDone.getOrDefault(resource.getLocation(), false).booleanValue()) {
            return;
        }
        LOG.trace("Pre-parsing: {}", (Object)resource.getLocation());
        if (!resource.exists()) {
            throw new FileNotFoundException("Resource not found: " + resource.getLocation());
        }
        try (InputStream is = this.resourceInputStream(resource);){
            LoadSettings local = LoadSettings.builder().setLabel(resource.getLocation()).build();
            YamlDeserializationContext ctx = this.newYamlDeserializationContext(local, resource);
            StreamReader reader = new StreamReader(local, (Reader)new YamlUnicodeReader(is));
            ParserImpl parser = new ParserImpl(local, reader);
            Composer composer = new Composer(local, (Parser)parser);
            try {
                composer.getSingleNode().map(node -> this.preParseNode(ctx, (Node)node));
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error pre-parsing resource: " + ctx.getResource().getLocation(), (Throwable)e);
            }
            finally {
                ctx.close();
            }
        }
        this.preparseDone.put(resource.getLocation(), true);
    }

    private Object preParseNode(YamlDeserializationContext ctx, Node root) {
        LOG.trace("Pre-parsing node: {}", (Object)root);
        YamlDeserializerSupport.setDeserializationContext((Node)root, (YamlDeserializationContext)ctx);
        Object target = this.preConfigureNode(root, ctx, true);
        Iterator it = ObjectHelper.createIterator((Object)target);
        while (it.hasNext()) {
            target = it.next();
            if (!(target instanceof CamelContextCustomizer)) continue;
            CamelContextCustomizer customizer = (CamelContextCustomizer)target;
            customizer.configure(this.getCamelContext());
        }
        return null;
    }
}

