/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.yaml.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringJoiner;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.catalog.JSonSchemaResolver;
import org.apache.camel.catalog.impl.DefaultRuntimeCamelCatalog;
import org.apache.camel.catalog.impl.URISupport;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.EipModel;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.yaml.io.EipNode;
import org.apache.camel.yaml.io.ModelJSonSchemaResolver;

public class YamlWriter
extends ServiceSupport
implements CamelContextAware {
    private CamelContext camelContext;
    private final Writer writer;
    private DefaultRuntimeCamelCatalog catalog;
    private final List<EipModel> roots = new ArrayList<EipModel>();
    private boolean routesIsRoot;
    private final Stack<EipModel> models = new Stack();
    private String expression;
    private boolean uriAsParameters;

    public YamlWriter(Writer writer) {
        this.writer = writer;
        this.catalog = new DefaultRuntimeCamelCatalog();
        this.catalog.setJSonSchemaResolver((JSonSchemaResolver)new ModelJSonSchemaResolver());
        this.catalog.setCaching(false);
        this.catalog.start();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void doStart() throws Exception {
        DefaultRuntimeCamelCatalog runtime;
        if (this.camelContext != null && (runtime = (DefaultRuntimeCamelCatalog)PluginHelper.getRuntimeCamelCatalog((CamelContext)this.camelContext)) != null) {
            this.catalog.setJSonSchemaResolver(runtime.getJSonSchemaResolver());
        }
    }

    protected void doStop() throws Exception {
    }

    public void setUriAsParameters(boolean uriAsParameters) {
        this.uriAsParameters = uriAsParameters;
    }

    public void startElement(String name) throws IOException {
        if ("routes".equals(name)) {
            this.routesIsRoot = true;
            return;
        }
        EipModel model = this.catalog.eipModel(name);
        if (model == null) {
            return;
        }
        EipModel parent = this.models.isEmpty() ? null : this.models.peek();
        model.getMetadata().put("_parent", parent);
        this.models.push(model);
        if (parent == null) {
            this.roots.add(model);
        }
    }

    public void startExpressionElement(String name) throws IOException {
        this.expression = name;
    }

    public void endExpressionElement(String name) throws IOException {
        this.expression = null;
    }

    public void endElement(String name) throws IOException {
        EipModel last;
        if ("routes".equals(name)) {
            this.writer.write(this.toYaml());
            return;
        }
        EipModel model = this.catalog.eipModel(name);
        if (model == null) {
            return;
        }
        EipModel eipModel = last = this.models.isEmpty() ? null : this.models.peek();
        if (last != null && YamlWriter.isLanguage(last)) {
            String key;
            EipModel parent;
            if (!this.models.isEmpty()) {
                this.models.pop();
            }
            EipModel eipModel2 = parent = this.models.isEmpty() ? null : this.models.peek();
            if (parent != null && (key = YamlWriter.expressionName(parent, this.expression)) != null) {
                parent.getMetadata().put(key, last);
            }
            return;
        }
        if (last != null) {
            EipModel parent;
            if (!this.models.isEmpty()) {
                this.models.pop();
            }
            EipModel eipModel3 = parent = this.models.isEmpty() ? null : this.models.peek();
            if (parent != null) {
                if ("from".equals(name) && parent.isInput()) {
                    parent.getMetadata().put("_input", last);
                } else if ("choice".equals(parent.getName())) {
                    YamlWriter.setMetadata(parent, name, last);
                } else if (parent.isOutput()) {
                    ArrayList<EipModel> list = (ArrayList<EipModel>)parent.getMetadata().get("_output");
                    if (list == null) {
                        list = new ArrayList<EipModel>();
                        parent.getMetadata().put("_output", list);
                    }
                    list.add(last);
                } else if ("marshal".equals(parent.getName()) || "unmarshal".equals(parent.getName())) {
                    parent.getMetadata().put("_dataFormatType", last);
                }
            }
        }
        if (this.models.isEmpty() && !this.routesIsRoot) {
            this.writer.write(this.toYaml());
        }
    }

    public void writeText(String name, String text) throws IOException {
        EipModel last;
        EipModel eipModel = last = this.models.isEmpty() ? null : this.models.peek();
        if (last != null) {
            YamlWriter.setMetadata(last, name, text);
        }
    }

    public void writeValue(String value) throws IOException {
        String key;
        EipModel last;
        EipModel eipModel = last = this.models.isEmpty() ? null : this.models.peek();
        if (last != null && (key = YamlWriter.valueName(last)) != null) {
            last.getMetadata().put(key, value);
        }
    }

    public void addAttribute(String name, Object value) throws IOException {
        EipModel last;
        EipModel eipModel = last = this.models.isEmpty() ? null : this.models.peek();
        if (last != null) {
            if (this.uriAsParameters && "uri".equals(name) && value != null) {
                String base2;
                try {
                    Map parameters;
                    base2 = StringHelper.before((String)value.toString(), (String)":");
                    if (base2 != null && !(parameters = this.catalog.endpointProperties(value.toString())).isEmpty()) {
                        YamlWriter.prepareParameters(parameters);
                        last.getMetadata().put("uri", base2);
                        last.getMetadata().put("parameters", parameters);
                        return;
                    }
                }
                catch (Exception base2) {
                    // empty catch block
                }
                try {
                    Map parameters;
                    base2 = URISupport.stripQuery((String)value.toString());
                    String query = URISupport.extractQuery((String)value.toString());
                    if (base2 != null && query != null && !(parameters = URISupport.parseQuery((String)query)).isEmpty()) {
                        YamlWriter.prepareParameters(parameters);
                        last.getMetadata().put("uri", base2);
                        last.getMetadata().put("parameters", parameters);
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            last.getMetadata().put(name, value);
        }
    }

    private static void prepareParameters(Map<String, Object> parameters) {
        parameters.forEach((k, v) -> {
            if ("true".equals(v) || "false".equals(v)) {
                Boolean s = Boolean.valueOf(v.toString());
                parameters.replace((String)k, s);
            }
        });
    }

    private EipNode asExpressionNode(EipModel model, String name) {
        EipNode node = new EipNode(name, null, false, true);
        this.doAsNode(model, node);
        return node;
    }

    private EipNode asNode(EipModel model) {
        EipNode node = new EipNode(model.getName(), null, false, false);
        this.doAsNode(model, node);
        return node;
    }

    private void doAsNode(EipModel model, EipNode node) {
        for (Map.Entry entry : model.getMetadata().entrySet()) {
            Object v;
            boolean skip;
            EipModel m;
            String key = (String)entry.getKey();
            if ("_input".equals(key)) {
                EipModel m2 = (EipModel)entry.getValue();
                node.setInput(this.asNode(m2));
                continue;
            }
            if ("_output".equals(key)) {
                List list = (List)entry.getValue();
                for (Object m3 : list) {
                    node.addOutput(this.asNode((EipModel)m3));
                }
                continue;
            }
            if ("choice".equals(node.getName()) && "otherwise".equals(key)) {
                EipModel other = (EipModel)entry.getValue();
                node.addOutput(this.asNode(other));
                continue;
            }
            if ("choice".equals(node.getName()) && "when".equals(key)) {
                Object v2 = entry.getValue();
                if (v2 instanceof List) {
                    Object m3;
                    List list = (List)v2;
                    m3 = list.iterator();
                    while (m3.hasNext()) {
                        m = (EipModel)m3.next();
                        node.addOutput(this.asNode(m));
                    }
                    continue;
                }
                node.addOutput(this.asNode((EipModel)v2));
                continue;
            }
            if (("marshal".equals(node.getName()) || "unmarshal".equals(node.getName())) && "_dataFormatType".equals(key)) {
                EipModel other = (EipModel)entry.getValue();
                node.addOutput(this.asNode(other));
                continue;
            }
            boolean bl = skip = key.startsWith("_") || key.equals("customId");
            if (skip) continue;
            String exp = null;
            if (!YamlWriter.isLanguage(model)) {
                exp = YamlWriter.expressionName(model, key);
            }
            if ((v = entry.getValue()) instanceof EipModel) {
                m = (EipModel)entry.getValue();
                v = exp == null || "expression".equals(exp) ? this.asExpressionNode(m, m.getName()) : this.asExpressionNode(m, exp);
            }
            if (exp != null && v instanceof EipNode) {
                node.addExpression((EipNode)v);
                continue;
            }
            node.addProperty(key, v);
            if (!"expression".equals(key)) continue;
            node.addProperty("language", model.getName());
        }
    }

    public String toYaml() {
        try {
            JsonArray arr = this.transformToJson(this.roots);
            JsonNode jsonNodeTree = new ObjectMapper().readTree(arr.toJson());
            YAMLMapper mapper = new YAMLMapper();
            mapper.disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER);
            mapper.enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
            mapper.enable(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR);
            String jsonAsYaml = mapper.writeValueAsString((Object)jsonNodeTree);
            StringJoiner sj = new StringJoiner("\n");
            for (String line : jsonAsYaml.split("\n")) {
                if (line.startsWith("  ")) {
                    line = line.substring(2);
                }
                sj.add(line);
            }
            sj.add("");
            jsonAsYaml = sj.toString();
            return jsonAsYaml;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JsonArray transformToJson(List<EipModel> models) {
        JsonArray arr = new JsonArray();
        for (EipModel model : models) {
            JsonObject jo = this.asJSonNode(model);
            arr.add((Object)jo);
        }
        return arr;
    }

    private JsonObject asJSonNode(EipModel model) {
        JsonObject answer = new JsonObject();
        JsonObject jo = new JsonObject();
        answer.put((Object)model.getName(), (Object)jo);
        for (Map.Entry entry : model.getMetadata().entrySet()) {
            Object value;
            String key = (String)entry.getKey();
            boolean skip = key.equals("customId");
            if (skip || (value = entry.getValue()) == null) continue;
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                ArrayList list = new ArrayList();
                for (Object v : col) {
                    Object r = v;
                    if (r instanceof EipModel) {
                        EipNode en = this.asNode((EipModel)r);
                        value = en.asJsonObject();
                        JsonObject wrap = new JsonObject();
                        wrap.put((Object)en.getName(), value);
                        r = wrap;
                    }
                    list.add(r);
                }
                if ("_output".equals(key)) {
                    key = "steps";
                }
                if (jo.containsKey((Object)"from")) {
                    jo = (JsonObject)jo.getMap("from");
                }
                jo.put((Object)key, list);
                continue;
            }
            if (value instanceof EipModel) {
                EipNode r = this.asNode((EipModel)value);
                value = r.asJsonObject();
                jo.put((Object)r.getName(), value);
                continue;
            }
            jo.put((Object)key, value);
        }
        return answer;
    }

    private static void setMetadata(EipModel model, String name, Object value) {
        boolean array = YamlWriter.isArray(model, name);
        if (array) {
            ArrayList<Object> list = (ArrayList<Object>)model.getMetadata().get(name);
            if (list == null) {
                list = new ArrayList<Object>();
                model.getMetadata().put(name, list);
            }
            list.add(value);
        } else {
            model.getMetadata().put(name, value);
        }
    }

    private static String valueName(EipModel model) {
        return model.getOptions().stream().filter(o -> "value".equals(o.getKind())).map(BaseOptionModel::getName).findFirst().orElse(null);
    }

    private static String expressionName(EipModel model, String name) {
        return model.getOptions().stream().filter(o -> "expression".equals(o.getKind())).map(BaseOptionModel::getName).filter(oName -> name == null || oName.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    private static boolean isArray(EipModel model, String name) {
        return model.getOptions().stream().filter(o -> o.getName().equalsIgnoreCase(name)).map(o -> "array".equals(o.getType())).findFirst().orElse(false);
    }

    private static boolean isLanguage(EipModel model) {
        return model.getJavaType().startsWith("org.apache.camel.model.language");
    }
}

