/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.zipfile;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.camel.Message;
import org.apache.camel.dataformat.zipfile.ZipInputStreamWrapper;
import org.apache.camel.impl.DefaultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZipIterator
implements Iterator<Message> {
    static final Logger LOGGER = LoggerFactory.getLogger(ZipIterator.class);
    private final Message inputMessage;
    private ZipInputStream zipInputStream;
    private Message parent;

    public ZipIterator(Message inputMessage) {
        this.inputMessage = inputMessage;
        InputStream inputStream = (InputStream)inputMessage.getBody(InputStream.class);
        this.zipInputStream = inputStream instanceof ZipInputStream ? (ZipInputStream)inputStream : new ZipInputStream(new BufferedInputStream(inputStream));
        this.parent = null;
    }

    @Override
    public boolean hasNext() {
        try {
            boolean availableDataInCurrentEntry;
            if (this.zipInputStream == null) {
                return false;
            }
            boolean bl = availableDataInCurrentEntry = this.zipInputStream.available() == 1;
            if (!availableDataInCurrentEntry) {
                this.parent = this.getNextElement();
                boolean bl2 = availableDataInCurrentEntry = this.zipInputStream.available() == 1;
                if (!availableDataInCurrentEntry) {
                    this.zipInputStream.close();
                }
            }
            return availableDataInCurrentEntry;
        }
        catch (IOException e) {
            LOGGER.error("Fail hasNext()", (Throwable)e);
            return false;
        }
    }

    @Override
    public Message next() {
        if (this.parent == null) {
            this.parent = this.getNextElement();
        }
        Message answer = this.parent;
        this.parent = null;
        this.checkNullAnswer(answer);
        return answer;
    }

    private Message getNextElement() {
        DefaultMessage answer = null;
        if (this.zipInputStream != null) {
            try {
                ZipEntry current = this.zipInputStream.getNextEntry();
                if (current != null) {
                    LOGGER.debug("read zipEntry {}", (Object)current.getName());
                    answer = new DefaultMessage();
                    answer.setHeaders(this.inputMessage.getHeaders());
                    answer.setHeader("zipFileName", (Object)current.getName());
                    answer.setHeader("CamelFileName", (Object)current.getName());
                    answer.setBody((Object)new ZipInputStreamWrapper(this.zipInputStream));
                    return answer;
                }
                LOGGER.trace("close zipInputStream");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkNullAnswer(Message answer) {
        if (answer == null && this.zipInputStream != null) {
            try {
                this.zipInputStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.zipInputStream = null;
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

