/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.zipfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileMessage;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.FileUtil;

public class ZipAggregationStrategy
implements AggregationStrategy {
    private String filePrefix;
    private String fileSuffix = ".zip";
    private boolean preserveFolderStructure;

    public ZipAggregationStrategy() {
        this(false);
    }

    public ZipAggregationStrategy(boolean preserveFolderStructure) {
        this.preserveFolderStructure = preserveFolderStructure;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        File zipFile;
        Exchange answer = oldExchange;
        if (newExchange == null) {
            return oldExchange;
        }
        if (oldExchange == null) {
            try {
                zipFile = FileUtil.createTempFile((String)this.filePrefix, (String)this.fileSuffix);
            }
            catch (IOException e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
            DefaultEndpoint endpoint = (DefaultEndpoint)newExchange.getFromEndpoint();
            answer = endpoint.createExchange();
            answer.addOnCompletion((Synchronization)new DeleteZipFileOnCompletion(zipFile));
        } else {
            zipFile = (File)oldExchange.getIn().getBody(File.class);
        }
        if (GenericFileMessage.class.isAssignableFrom(newExchange.getIn().getClass())) {
            try {
                File appendFile = (File)newExchange.getIn().getBody(File.class);
                if (appendFile == null) {
                    throw new GenericFileOperationFailedException("Could not get body as file.");
                }
                ZipAggregationStrategy.addFileToZip(zipFile, appendFile, this.preserveFolderStructure ? newExchange.getIn().toString() : null);
                GenericFile genericFile = FileConsumer.asGenericFile((String)zipFile.getParent(), (File)zipFile, (String)Charset.defaultCharset().toString());
                genericFile.bindToExchange(answer);
            }
            catch (IOException e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
        }
        byte[] buffer = (byte[])newExchange.getIn().getBody(byte[].class);
        try {
            ZipAggregationStrategy.addEntryToZip(zipFile, newExchange.getIn().getMessageId(), buffer, buffer.length);
            GenericFile genericFile = FileConsumer.asGenericFile((String)zipFile.getParent(), (File)zipFile, (String)Charset.defaultCharset().toString());
            genericFile.bindToExchange(answer);
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
        }
        return answer;
    }

    private static void addFileToZip(File source, File file, String fileName) throws IOException {
        File tmpZip = File.createTempFile(source.getName(), null);
        tmpZip.delete();
        if (!source.renameTo(tmpZip)) {
            throw new IOException("Could not make temp file (" + source.getName() + ")");
        }
        byte[] buffer = new byte[1024];
        ZipInputStream zin = new ZipInputStream(new FileInputStream(tmpZip));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(source));
        FileInputStream in = new FileInputStream(file);
        out.putNextEntry(new ZipEntry(fileName == null ? file.getName() : fileName));
        int read = ((InputStream)in).read(buffer);
        while (read > -1) {
            out.write(buffer, 0, read);
            read = ((InputStream)in).read(buffer);
        }
        out.closeEntry();
        ((InputStream)in).close();
        ZipEntry ze = zin.getNextEntry();
        while (ze != null) {
            out.putNextEntry(ze);
            int read2 = zin.read(buffer);
            while (read2 > -1) {
                out.write(buffer, 0, read2);
                read2 = zin.read(buffer);
            }
            out.closeEntry();
            ze = zin.getNextEntry();
        }
        zin.close();
        out.close();
        tmpZip.delete();
    }

    private static void addEntryToZip(File source, String entryName, byte[] buffer, int length) throws IOException {
        File tmpZip = File.createTempFile(source.getName(), null);
        tmpZip.delete();
        if (!source.renameTo(tmpZip)) {
            throw new IOException("Could not make temp file (" + source.getName() + ")");
        }
        ZipInputStream zin = new ZipInputStream(new FileInputStream(tmpZip));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(source));
        out.putNextEntry(new ZipEntry(entryName));
        out.write(buffer, 0, length);
        out.closeEntry();
        ZipEntry ze = zin.getNextEntry();
        while (ze != null) {
            out.putNextEntry(ze);
            int read = zin.read(buffer);
            while (read > -1) {
                out.write(buffer, 0, read);
                read = zin.read(buffer);
            }
            out.closeEntry();
            ze = zin.getNextEntry();
        }
        zin.close();
        out.close();
        tmpZip.delete();
    }

    private class DeleteZipFileOnCompletion
    implements Synchronization {
        private File fileToDelete;

        public DeleteZipFileOnCompletion(File fileToDelete) {
            this.fileToDelete = fileToDelete;
        }

        public void onFailure(Exchange exchange) {
        }

        public void onComplete(Exchange exchange) {
            FileUtil.deleteFile((File)this.fileToDelete);
        }
    }
}

