/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.zipfile;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;

public class ZipAggregationStrategy
implements AggregationStrategy {
    private String filePrefix;
    private String fileSuffix = ".zip";
    private boolean preserveFolderStructure;
    private boolean useFilenameHeader;
    private File parentDir = new File(System.getProperty("java.io.tmpdir"));

    public ZipAggregationStrategy() {
        this(false, false);
    }

    public ZipAggregationStrategy(boolean preserveFolderStructure) {
        this(preserveFolderStructure, false);
    }

    public ZipAggregationStrategy(boolean preserveFolderStructure, boolean useFilenameHeader) {
        this.preserveFolderStructure = preserveFolderStructure;
        this.useFilenameHeader = useFilenameHeader;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public File getParentDir() {
        return this.parentDir;
    }

    public void setParentDir(File parentDir) {
        this.parentDir = parentDir;
    }

    public void setParentDir(String parentDir) {
        this.parentDir = new File(parentDir);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        File zipFile;
        Exchange answer = oldExchange;
        if (newExchange == null) {
            return oldExchange;
        }
        if (oldExchange == null) {
            try {
                zipFile = FileUtil.createTempFile((String)this.filePrefix, (String)this.fileSuffix, (File)this.parentDir);
            }
            catch (IOException e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
            answer = newExchange;
            answer.addOnCompletion((Synchronization)new DeleteZipFileOnCompletion(zipFile));
        } else {
            zipFile = (File)oldExchange.getIn().getBody(File.class);
        }
        Object body = newExchange.getIn().getBody();
        if (body instanceof WrappedFile) {
            body = ((WrappedFile)body).getFile();
        }
        if (body instanceof File) {
            try {
                File appendFile = (File)body;
                if (appendFile.length() <= 0L) return answer;
                String entryName = this.preserveFolderStructure ? (String)newExchange.getIn().getHeader("CamelFileName", String.class) : newExchange.getIn().getMessageId();
                ZipAggregationStrategy.addFileToZip(zipFile, appendFile, this.preserveFolderStructure ? entryName : null);
                GenericFile genericFile = FileConsumer.asGenericFile((String)zipFile.getParent(), (File)zipFile, (String)Charset.defaultCharset().toString(), (boolean)false);
                genericFile.bindToExchange(answer);
                return answer;
            }
            catch (Exception e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            byte[] buffer = (byte[])newExchange.getIn().getMandatoryBody(byte[].class);
            if (buffer.length <= 0) return answer;
            String entryName = this.useFilenameHeader ? (String)newExchange.getIn().getHeader("CamelFileName", String.class) : newExchange.getIn().getMessageId();
            ZipAggregationStrategy.addEntryToZip(zipFile, entryName, buffer, buffer.length);
            GenericFile genericFile = FileConsumer.asGenericFile((String)zipFile.getParent(), (File)zipFile, (String)Charset.defaultCharset().toString(), (boolean)false);
            genericFile.bindToExchange(answer);
            return answer;
        }
        catch (Exception e) {
            throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFileToZip(File source, File file, String fileName) throws IOException {
        File tmpZip = Files.createTempFile(source.getName(), null, new FileAttribute[0]).toFile();
        tmpZip.delete();
        if (!source.renameTo(tmpZip)) {
            throw new IOException("Could not make temp file (" + source.getName() + ")");
        }
        byte[] buffer = new byte[8192];
        FileInputStream fis = new FileInputStream(tmpZip);
        ZipInputStream zin = new ZipInputStream(fis);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(source));
        try {
            FileInputStream in = new FileInputStream(file);
            out.putNextEntry(new ZipEntry(fileName == null ? file.getName() : fileName));
            int read = ((InputStream)in).read(buffer);
            while (read > -1) {
                out.write(buffer, 0, read);
                read = ((InputStream)in).read(buffer);
            }
            out.closeEntry();
            IOHelper.close((Closeable)in);
            ZipEntry ze = zin.getNextEntry();
            while (ze != null) {
                out.putNextEntry(ze);
                int read2 = zin.read(buffer);
                while (read2 > -1) {
                    out.write(buffer, 0, read2);
                    read2 = zin.read(buffer);
                }
                out.closeEntry();
                ze = zin.getNextEntry();
            }
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{fis, zin, out});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{fis, zin, out});
        tmpZip.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEntryToZip(File source, String entryName, byte[] buffer, int length) throws IOException {
        File tmpZip = Files.createTempFile(source.getName(), null, new FileAttribute[0]).toFile();
        tmpZip.delete();
        if (!source.renameTo(tmpZip)) {
            throw new IOException("Cannot create temp file: " + source.getName());
        }
        FileInputStream fis = new FileInputStream(tmpZip);
        ZipInputStream zin = new ZipInputStream(fis);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(source));
        try {
            out.putNextEntry(new ZipEntry(entryName));
            out.write(buffer, 0, length);
            out.closeEntry();
            ZipEntry ze = zin.getNextEntry();
            while (ze != null) {
                out.putNextEntry(ze);
                int read = zin.read(buffer);
                while (read > -1) {
                    out.write(buffer, 0, read);
                    read = zin.read(buffer);
                }
                out.closeEntry();
                ze = zin.getNextEntry();
            }
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{fis, zin, out});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{fis, zin, out});
        tmpZip.delete();
    }

    private class DeleteZipFileOnCompletion
    implements Synchronization {
        private final File fileToDelete;

        DeleteZipFileOnCompletion(File fileToDelete) {
            this.fileToDelete = fileToDelete;
        }

        public void onFailure(Exchange exchange) {
        }

        public void onComplete(Exchange exchange) {
            FileUtil.deleteFile((File)this.fileToDelete);
        }
    }
}

