/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.zipfile;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.FileUtil;

public class ZipAggregationStrategy
implements AggregationStrategy {
    private String filePrefix;
    private String fileSuffix = ".zip";
    private boolean preserveFolderStructure;
    private boolean useFilenameHeader;
    private boolean useTempFile;
    private File parentDir = new File(System.getProperty("java.io.tmpdir"));

    public ZipAggregationStrategy() {
        this(false);
    }

    public ZipAggregationStrategy(boolean preserveFolderStructure) {
        this(preserveFolderStructure, false);
    }

    public ZipAggregationStrategy(boolean preserveFolderStructure, boolean useFilenameHeader) {
        this(preserveFolderStructure, useFilenameHeader, false);
    }

    public ZipAggregationStrategy(boolean preserveFolderStructure, boolean useFilenameHeader, boolean useTempFile) {
        this.preserveFolderStructure = preserveFolderStructure;
        this.useFilenameHeader = useFilenameHeader;
        this.useTempFile = useTempFile;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public File getParentDir() {
        return this.parentDir;
    }

    public void setParentDir(File parentDir) {
        this.parentDir = parentDir;
    }

    public void setParentDir(String parentDir) {
        this.parentDir = new File(parentDir);
    }

    /*
     * Unable to fully structure code
     */
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        answer = oldExchange;
        if (newExchange == null) {
            return oldExchange;
        }
        if (oldExchange == null) {
            try {
                zipFile = FileUtil.createTempFile((String)this.filePrefix, (String)this.fileSuffix, (File)this.parentDir);
                ZipAggregationStrategy.newZipFile(zipFile);
            }
            catch (IOException | URISyntaxException e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
            answer = newExchange;
            answer.getExchangeExtension().addOnCompletion((Synchronization)new DeleteZipFileOnCompletion(zipFile));
        } else {
            zipFile = (File)oldExchange.getIn().getBody(File.class);
        }
        body = newExchange.getIn().getBody();
        if (body instanceof WrappedFile) {
            body = ((WrappedFile)body).getFile();
        }
        charset = ExchangeHelper.getCharsetName((Exchange)newExchange, (boolean)true);
        if (body instanceof File) {
            try {
                appendFile = (File)body;
                if (appendFile.length() <= 0L) ** GOTO lbl36
                entryName = this.preserveFolderStructure != false ? (String)newExchange.getIn().getHeader("CamelFileName", String.class) : newExchange.getIn().getMessageId();
                this.addFileToZip(zipFile, appendFile, this.preserveFolderStructure != false ? entryName : null);
            }
            catch (Exception e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                buffer = (byte[])newExchange.getIn().getMandatoryBody(byte[].class);
                if (buffer.length > 0) {
                    entryName = this.useFilenameHeader != false ? (String)newExchange.getIn().getHeader("CamelFileName", String.class) : newExchange.getIn().getMessageId();
                    this.addEntryToZip(zipFile, entryName, buffer, charset);
                }
            }
            catch (Exception e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
        }
lbl36:
        // 3 sources

        genericFile = FileConsumer.asGenericFile((String)zipFile.getParent(), (File)zipFile, (String)charset, (boolean)false);
        genericFile.bindToExchange(answer);
        return answer;
    }

    public void onCompletion(Exchange exchange, Exchange inputExchange) {
        if (inputExchange != null) {
            exchange.getExchangeExtension().handoverCompletions(inputExchange);
        }
    }

    private static void newZipFile(File zipFile) throws URISyntaxException, IOException {
        if (zipFile.exists() && !zipFile.delete()) {
            throw new IOException("Cannot delete file " + String.valueOf(zipFile));
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", Boolean.TRUE.toString());
        FileSystem ignored = FileSystems.newFileSystem(ZipAggregationStrategy.getZipURI(zipFile), env);
        if (ignored != null) {
            ignored.close();
        }
    }

    private void addFileToZip(File zipFile, File file, String fileName) throws IOException, URISyntaxException {
        String entryName = fileName == null ? file.getName() : fileName;
        HashMap<String, Boolean> env = new HashMap<String, Boolean>();
        env.put("useTempFile", this.useTempFile);
        try (FileSystem fs = FileSystems.newFileSystem(ZipAggregationStrategy.getZipURI(zipFile), env);){
            Path dest = fs.getPath("/", entryName);
            Path parent = dest.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
                Files.copy(file.toPath(), dest, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private void addEntryToZip(File zipFile, String entryName, byte[] buffer, String charset) throws IOException, URISyntaxException {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("encoding", charset);
        env.put("useTempFile", this.useTempFile);
        try (FileSystem fs = FileSystems.newFileSystem(ZipAggregationStrategy.getZipURI(zipFile), env);){
            Path dest = fs.getPath("/", entryName);
            Path parent = dest.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
                Files.write(dest, buffer, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
    }

    private static URI getZipURI(File zipFile) throws URISyntaxException {
        return new URI("jar", zipFile.toURI().toString(), null);
    }

    private static class DeleteZipFileOnCompletion
    implements Synchronization {
        private final File fileToDelete;

        DeleteZipFileOnCompletion(File fileToDelete) {
            this.fileToDelete = fileToDelete;
        }

        public void onFailure(Exchange exchange) {
        }

        public void onComplete(Exchange exchange) {
            FileUtil.deleteFile((File)this.fileToDelete);
        }
    }
}

