/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.zipkin;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ClientRequestAdapter;
import com.github.kristofa.brave.ClientResponseAdapter;
import com.github.kristofa.brave.ClientSpanThreadBinder;
import com.github.kristofa.brave.Sampler;
import com.github.kristofa.brave.ServerRequestAdapter;
import com.github.kristofa.brave.ServerResponseAdapter;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.ServerSpanThreadBinder;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.scribe.ScribeSpanCollector;
import com.twitter.zipkin.gen.Span;
import java.io.Closeable;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.properties.ServiceHostPropertiesFunction;
import org.apache.camel.component.properties.ServicePortPropertiesFunction;
import org.apache.camel.management.event.ExchangeCompletedEvent;
import org.apache.camel.management.event.ExchangeCreatedEvent;
import org.apache.camel.management.event.ExchangeFailedEvent;
import org.apache.camel.management.event.ExchangeSendingEvent;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.zipkin.ZipkinClientRequestAdapter;
import org.apache.camel.zipkin.ZipkinClientResponseAdaptor;
import org.apache.camel.zipkin.ZipkinServerRequestAdapter;
import org.apache.camel.zipkin.ZipkinServerResponseAdapter;
import org.apache.camel.zipkin.ZipkinState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="ZipkinTracer")
public class ZipkinTracer
extends ServiceSupport
implements RoutePolicyFactory,
StaticService,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(ZipkinTracer.class);
    private static final String ZIPKIN_COLLECTOR_THRIFT_SERVICE = "zipkin-collector-thrift";
    private final ZipkinEventNotifier eventNotifier = new ZipkinEventNotifier();
    private final Map<String, Brave> braves = new HashMap<String, Brave>();
    private transient boolean useFallbackServiceNames;
    private CamelContext camelContext;
    private String hostName;
    private int port;
    private float rate = 1.0f;
    private SpanCollector spanCollector;
    private Map<String, String> clientServiceMappings = new HashMap<String, String>();
    private Map<String, String> serverServiceMappings = new HashMap<String, String>();
    private Set<String> excludePatterns = new HashSet<String>();
    private boolean includeMessageBody;
    private boolean includeMessageBodyStreams;

    public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, RouteDefinition route) {
        this.init(camelContext);
        return new ZipkinRoutePolicy(routeId);
    }

    public void init(CamelContext camelContext) {
        if (!camelContext.hasService((Object)this)) {
            try {
                camelContext.addService((Object)this, true, true);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @ManagedAttribute(description="The hostname for the remote zipkin server to use.")
    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @ManagedAttribute(description="The port number for the remote zipkin server to use.")
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @ManagedAttribute(description="Rates how many events should be traced by zipkin. The rate is expressed as a percentage (1.0f = 100%, 0.5f is 50%, 0.1f is 10%).")
    public float getRate() {
        return this.rate;
    }

    public void setRate(float rate) {
        this.rate = rate;
    }

    public SpanCollector getSpanCollector() {
        return this.spanCollector;
    }

    public void setSpanCollector(SpanCollector spanCollector) {
        this.spanCollector = spanCollector;
    }

    public String getServiceName() {
        return this.clientServiceMappings.get("*");
    }

    public void setServiceName(String serviceName) {
        this.clientServiceMappings.put("*", serviceName);
        this.serverServiceMappings.put("*", serviceName);
    }

    public Map<String, String> getClientServiceMappings() {
        return this.clientServiceMappings;
    }

    public void setClientServiceMappings(Map<String, String> clientServiceMappings) {
        this.clientServiceMappings = clientServiceMappings;
    }

    public void addClientServiceMapping(String pattern, String serviceName) {
        this.clientServiceMappings.put(pattern, serviceName);
    }

    public Map<String, String> getServerServiceMappings() {
        return this.serverServiceMappings;
    }

    public void setServerServiceMappings(Map<String, String> serverServiceMappings) {
        this.serverServiceMappings = serverServiceMappings;
    }

    public void addServerServiceMapping(String pattern, String serviceName) {
        this.serverServiceMappings.put(pattern, serviceName);
    }

    public Set<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public void setExcludePatterns(Set<String> excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public void addExcludePattern(String pattern) {
        this.excludePatterns.add(pattern);
    }

    @ManagedAttribute(description="Whether to include the Camel message body in the zipkin traces")
    public boolean isIncludeMessageBody() {
        return this.includeMessageBody;
    }

    @ManagedAttribute(description="Whether to include the Camel message body in the zipkin traces")
    public void setIncludeMessageBody(boolean includeMessageBody) {
        this.includeMessageBody = includeMessageBody;
    }

    @ManagedAttribute(description="Whether to include stream based Camel message bodies in the zipkin traces")
    public boolean isIncludeMessageBodyStreams() {
        return this.includeMessageBodyStreams;
    }

    @ManagedAttribute(description="Whether to include stream based Camel message bodies in the zipkin traces")
    public void setIncludeMessageBodyStreams(boolean includeMessageBodyStreams) {
        this.includeMessageBodyStreams = includeMessageBodyStreams;
    }

    protected void doStart() throws Exception {
        String serviceName;
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        this.camelContext.getManagementStrategy().addEventNotifier((EventNotifier)this.eventNotifier);
        if (!this.camelContext.getRoutePolicyFactories().contains((Object)this)) {
            this.camelContext.addRoutePolicyFactory((RoutePolicyFactory)this);
        }
        if (this.spanCollector == null) {
            if (this.hostName != null && this.port > 0) {
                LOG.info("Configuring Zipkin ScribeSpanCollector using host: {} and port: {}", (Object)this.hostName, (Object)this.port);
                this.spanCollector = new ScribeSpanCollector(this.hostName, this.port);
            } else {
                String host = new ServiceHostPropertiesFunction().apply(ZIPKIN_COLLECTOR_THRIFT_SERVICE);
                String port = new ServicePortPropertiesFunction().apply(ZIPKIN_COLLECTOR_THRIFT_SERVICE);
                if (ObjectHelper.isNotEmpty((Object)host) && ObjectHelper.isNotEmpty((Object)port)) {
                    LOG.info("Auto-configuring Zipkin ScribeSpanCollector using host: {} and port: {}", (Object)host, (Object)port);
                    int num = (Integer)this.camelContext.getTypeConverter().mandatoryConvertTo(Integer.class, (Object)port);
                    this.spanCollector = new ScribeSpanCollector(host, num);
                }
            }
        }
        ObjectHelper.notNull((Object)this.spanCollector, (String)"SpanCollector", (Object)((Object)this));
        if (this.clientServiceMappings.isEmpty() && this.serverServiceMappings.isEmpty()) {
            LOG.warn("No service name(s) has been mapped in clientServiceMappings or serverServiceMappings. Camel will fallback and use endpoint uris as service names.");
            this.useFallbackServiceNames = true;
        }
        for (Map.Entry<String, String> entry : this.clientServiceMappings.entrySet()) {
            String pattern = entry.getKey();
            serviceName = entry.getValue();
            this.createBraveForService(pattern, serviceName);
        }
        for (Map.Entry<String, String> entry : this.serverServiceMappings.entrySet()) {
            String pattern = entry.getKey();
            serviceName = entry.getValue();
            this.createBraveForService(pattern, serviceName);
        }
        ServiceHelper.startServices((Object[])new Object[]{this.spanCollector, this.eventNotifier});
    }

    protected void doStop() throws Exception {
        this.camelContext.getManagementStrategy().removeEventNotifier((EventNotifier)this.eventNotifier);
        ServiceHelper.stopService((Object)((Object)this.eventNotifier));
        ServiceHelper.stopAndShutdownService((Object)this.spanCollector);
        if (this.spanCollector instanceof Closeable) {
            IOHelper.close((Closeable)((Closeable)this.spanCollector));
        }
        this.braves.clear();
        this.camelContext.getRoutePolicyFactories().remove((Object)this);
    }

    private String getServiceName(Exchange exchange, Endpoint endpoint, boolean server, boolean client) {
        if (client) {
            return this.getServiceName(exchange, endpoint, this.clientServiceMappings);
        }
        if (server) {
            return this.getServiceName(exchange, endpoint, this.serverServiceMappings);
        }
        return null;
    }

    private String getServiceName(Exchange exchange, Endpoint endpoint, Map<String, String> serviceMappings) {
        String id;
        String pattern;
        String url;
        String answer = null;
        if (endpoint != null && (url = endpoint.getEndpointUri()) != null) {
            for (String string : this.excludePatterns) {
                if (!EndpointHelper.matchEndpoint((CamelContext)exchange.getContext(), (String)url, (String)string)) continue;
                return null;
            }
            for (Map.Entry entry : serviceMappings.entrySet()) {
                pattern = (String)entry.getKey();
                if (!EndpointHelper.matchEndpoint((CamelContext)exchange.getContext(), (String)url, (String)pattern)) continue;
                answer = (String)entry.getValue();
                break;
            }
        }
        if (answer == null && (id = (String)ExpressionBuilder.routeIdExpression().evaluate(exchange, String.class)) != null) {
            for (String string : this.excludePatterns) {
                if (!EndpointHelper.matchPattern((String)id, (String)string)) continue;
                return null;
            }
            for (Map.Entry entry : serviceMappings.entrySet()) {
                pattern = (String)entry.getKey();
                if (!EndpointHelper.matchPattern((String)id, (String)pattern)) continue;
                answer = (String)entry.getValue();
                break;
            }
        }
        if (answer == null && (id = exchange.getFromRouteId()) != null) {
            for (String string : this.excludePatterns) {
                if (!EndpointHelper.matchPattern((String)id, (String)string)) continue;
                return null;
            }
            for (Map.Entry entry : serviceMappings.entrySet()) {
                pattern = (String)entry.getKey();
                if (!EndpointHelper.matchPattern((String)id, (String)pattern)) continue;
                answer = (String)entry.getValue();
                break;
            }
        }
        if (answer == null && this.useFallbackServiceNames) {
            String key = null;
            if (endpoint != null) {
                key = endpoint.getEndpointKey();
            } else if (exchange.getFromEndpoint() != null) {
                key = exchange.getFromEndpoint().getEndpointKey();
            }
            for (String string : this.excludePatterns) {
                if (!EndpointHelper.matchPattern((String)key, (String)string)) continue;
                return null;
            }
            if (LOG.isTraceEnabled() && key != null) {
                LOG.trace("Using serviceName: {} as fallback", (Object)key);
            }
            return key;
        }
        if (LOG.isTraceEnabled() && answer != null) {
            LOG.trace("Using serviceName: {}", answer);
        }
        return answer;
    }

    private void createBraveForService(String pattern, String serviceName) {
        Brave brave = this.braves.get(pattern);
        if (brave == null && !this.braves.containsKey(serviceName)) {
            Brave.Builder builder = new Brave.Builder(serviceName);
            builder = builder.traceSampler(Sampler.create((float)this.rate));
            if (this.spanCollector != null) {
                builder = builder.spanCollector(this.spanCollector);
            }
            brave = builder.build();
            this.braves.put(serviceName, brave);
        }
    }

    private Brave getBrave(String serviceName) {
        Brave brave = null;
        if (serviceName != null && (brave = this.braves.get(serviceName)) == null && this.useFallbackServiceNames) {
            LOG.debug("Creating Brave assigned to serviceName: {}", (Object)(serviceName + " as fallback"));
            Brave.Builder builder = new Brave.Builder(serviceName);
            builder = builder.traceSampler(Sampler.create((float)this.rate));
            if (this.spanCollector != null) {
                builder = builder.spanCollector(this.spanCollector);
            }
            brave = builder.build();
            this.braves.put(serviceName, brave);
        }
        return brave;
    }

    private void clientRequest(Brave brave, String serviceName, ExchangeSendingEvent event) {
        ServerSpan last;
        ClientSpanThreadBinder clientBinder = brave.clientSpanThreadBinder();
        ServerSpanThreadBinder serverBinder = brave.serverSpanThreadBinder();
        ZipkinState state = (ZipkinState)event.getExchange().getProperty("CamelZipkinState", ZipkinState.class);
        if (state == null) {
            state = new ZipkinState();
            event.getExchange().setProperty("CamelZipkinState", (Object)state);
        }
        if ((last = state.peekServerSpan()) != null) {
            serverBinder.setCurrentSpan(last);
        }
        brave.clientRequestInterceptor().handle((ClientRequestAdapter)new ZipkinClientRequestAdapter(this, serviceName, event.getExchange(), event.getEndpoint()));
        Span span = clientBinder.getCurrentClientSpan();
        state.pushClientSpan(span);
        clientBinder.setCurrentSpan(null);
        serverBinder.setCurrentSpan(null);
        if (span != null && LOG.isDebugEnabled()) {
            String parentId;
            String traceId = "" + span.getTrace_id();
            String spanId = "" + span.getId();
            String string = parentId = span.getParent_id() != null ? "" + span.getParent_id() : null;
            if (LOG.isDebugEnabled()) {
                if (parentId != null) {
                    LOG.debug(String.format("clientRequest [service=%s, traceId=%20s, spanId=%20s, parentId=%20s]", serviceName, traceId, spanId, parentId));
                } else {
                    LOG.debug(String.format("clientRequest [service=%s, traceId=%20s, spanId=%20s]", serviceName, traceId, spanId));
                }
            }
        }
    }

    private void clientResponse(Brave brave, String serviceName, ExchangeSentEvent event) {
        Span span = null;
        ZipkinState state = (ZipkinState)event.getExchange().getProperty("CamelZipkinState", ZipkinState.class);
        if (state != null) {
            span = state.popClientSpan();
        }
        if (span != null) {
            ClientSpanThreadBinder clientBinder = brave.clientSpanThreadBinder();
            clientBinder.setCurrentSpan(span);
            brave.clientResponseInterceptor().handle((ClientResponseAdapter)new ZipkinClientResponseAdaptor(this, event.getExchange(), event.getEndpoint()));
            clientBinder.setCurrentSpan(null);
            if (LOG.isDebugEnabled()) {
                String parentId;
                String traceId = "" + span.getTrace_id();
                String spanId = "" + span.getId();
                String string = parentId = span.getParent_id() != null ? "" + span.getParent_id() : null;
                if (LOG.isDebugEnabled()) {
                    if (parentId != null) {
                        LOG.debug(String.format("clientResponse[service=%s, traceId=%20s, spanId=%20s, parentId=%20s]", serviceName, traceId, spanId, parentId));
                    } else {
                        LOG.debug(String.format("clientResponse[service=%s, traceId=%20s, spanId=%20s]", serviceName, traceId, spanId));
                    }
                }
            }
        }
    }

    private ServerSpan serverRequest(Brave brave, String serviceName, Exchange exchange) {
        ServerSpan last;
        ServerSpanThreadBinder serverBinder = brave.serverSpanThreadBinder();
        ZipkinState state = (ZipkinState)exchange.getProperty("CamelZipkinState", ZipkinState.class);
        if (state == null) {
            state = new ZipkinState();
            exchange.setProperty("CamelZipkinState", (Object)state);
        }
        if ((last = state.peekServerSpan()) != null) {
            serverBinder.setCurrentSpan(last);
        }
        brave.serverRequestInterceptor().handle((ServerRequestAdapter)new ZipkinServerRequestAdapter(this, exchange));
        ServerSpan span = serverBinder.getCurrentServerSpan();
        state.pushServerSpan(span);
        serverBinder.setCurrentSpan(null);
        if (span != null && span.getSpan() != null && LOG.isDebugEnabled()) {
            String parentId;
            String traceId = "" + span.getSpan().getTrace_id();
            String spanId = "" + span.getSpan().getId();
            String string = parentId = span.getSpan().getParent_id() != null ? "" + span.getSpan().getParent_id() : null;
            if (LOG.isDebugEnabled()) {
                if (parentId != null) {
                    LOG.debug(String.format("serverRequest [service=%s, traceId=%20s, spanId=%20s, parentId=%20s]", serviceName, traceId, spanId, parentId));
                } else {
                    LOG.debug(String.format("serverRequest [service=%s, traceId=%20s, spanId=%20s]", serviceName, traceId, spanId));
                }
            }
        }
        return span;
    }

    private void serverResponse(Brave brave, String serviceName, Exchange exchange) {
        ServerSpan span = null;
        ZipkinState state = (ZipkinState)exchange.getProperty("CamelZipkinState", ZipkinState.class);
        if (state != null) {
            span = state.popServerSpan();
        }
        if (span != null) {
            ServerSpanThreadBinder serverBinder = brave.serverSpanThreadBinder();
            serverBinder.setCurrentSpan(span);
            brave.serverResponseInterceptor().handle((ServerResponseAdapter)new ZipkinServerResponseAdapter(this, exchange));
            serverBinder.setCurrentSpan(null);
            if (span.getSpan() != null && LOG.isDebugEnabled()) {
                String parentId;
                String traceId = "" + span.getSpan().getTrace_id();
                String spanId = "" + span.getSpan().getId();
                String string = parentId = span.getSpan().getParent_id() != null ? "" + span.getSpan().getParent_id() : null;
                if (LOG.isDebugEnabled()) {
                    if (parentId != null) {
                        LOG.debug(String.format("serverResponse[service=%s, traceId=%20s, spanId=%20s, parentId=%20s]", serviceName, traceId, spanId, parentId));
                    } else {
                        LOG.debug(String.format("serverResponse[service=%s, traceId=%20s, spanId=%20s]", serviceName, traceId, spanId));
                    }
                }
            }
        }
    }

    private boolean hasZipkinTraceId(Exchange exchange) {
        return exchange.getIn().getHeader("X-B3-TraceId") != null;
    }

    private final class ZipkinRoutePolicy
    extends RoutePolicySupport {
        private final String routeId;

        ZipkinRoutePolicy(String routeId) {
            this.routeId = routeId;
        }

        public void onExchangeBegin(Route route, Exchange exchange) {
            String serviceName;
            Brave brave;
            if (ZipkinTracer.this.hasZipkinTraceId(exchange) && (brave = ZipkinTracer.this.getBrave(serviceName = ZipkinTracer.this.getServiceName(exchange, route.getEndpoint(), true, false))) != null) {
                ZipkinTracer.this.serverRequest(brave, serviceName, exchange);
            }
            exchange.addOnCompletion((Synchronization)new SynchronizationAdapter(){

                public void onAfterRoute(Route route, Exchange exchange) {
                    String serviceName = ZipkinTracer.this.getServiceName(exchange, route.getEndpoint(), true, false);
                    Brave brave = ZipkinTracer.this.getBrave(serviceName);
                    if (brave != null) {
                        ZipkinTracer.this.serverResponse(brave, serviceName, exchange);
                    }
                }

                public String toString() {
                    return "ZipkinTracerOnCompletion[" + ZipkinRoutePolicy.this.routeId + "]";
                }
            });
        }
    }

    private final class ZipkinEventNotifier
    extends EventNotifierSupport {
        private ZipkinEventNotifier() {
        }

        public void notify(EventObject event) throws Exception {
            ExchangeSentEvent ese;
            String serviceName;
            Brave brave;
            if (event instanceof ExchangeSendingEvent) {
                ExchangeSendingEvent ese2 = (ExchangeSendingEvent)event;
                String serviceName2 = ZipkinTracer.this.getServiceName(ese2.getExchange(), ese2.getEndpoint(), false, true);
                Brave brave2 = ZipkinTracer.this.getBrave(serviceName2);
                if (brave2 != null) {
                    ZipkinTracer.this.clientRequest(brave2, serviceName2, ese2);
                }
            } else if (event instanceof ExchangeSentEvent && (brave = ZipkinTracer.this.getBrave(serviceName = ZipkinTracer.this.getServiceName((ese = (ExchangeSentEvent)event).getExchange(), ese.getEndpoint(), false, true))) != null) {
                ZipkinTracer.this.clientResponse(brave, serviceName, ese);
            }
        }

        public boolean isEnabled(EventObject event) {
            return event instanceof ExchangeSendingEvent || event instanceof ExchangeSentEvent || event instanceof ExchangeCreatedEvent || event instanceof ExchangeCompletedEvent || event instanceof ExchangeFailedEvent;
        }

        public String toString() {
            return "ZipkinEventNotifier";
        }
    }
}

