/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.zipkin;

import com.github.kristofa.brave.KeyValueAnnotation;
import com.github.kristofa.brave.ServerRequestAdapter;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.TraceData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.zipkin.ZipkinHelper;
import org.apache.camel.zipkin.ZipkinTracer;

public class ZipkinServerRequestAdapter
implements ServerRequestAdapter {
    private final ZipkinTracer eventNotifier;
    private final Exchange exchange;
    private final Endpoint endpoint;
    private final String spanName;
    private final String url;

    public ZipkinServerRequestAdapter(ZipkinTracer eventNotifier, Exchange exchange) {
        this.eventNotifier = eventNotifier;
        this.exchange = exchange;
        this.endpoint = exchange.getFromEndpoint();
        this.spanName = URISupport.sanitizeUri((String)this.endpoint.getEndpointKey()).toLowerCase(Locale.US);
        this.url = URISupport.sanitizeUri((String)this.endpoint.getEndpointUri());
    }

    public TraceData getTraceData() {
        String sampled = (String)this.exchange.getIn().getHeader("X-B3-Sampled", (Object)"0", String.class);
        if (sampled.equals("0") || sampled.toLowerCase().equals("false")) {
            return TraceData.builder().sample(Boolean.valueOf(false)).build();
        }
        String traceId = (String)this.exchange.getIn().getHeader("X-B3-TraceId", String.class);
        String spanId = (String)this.exchange.getIn().getHeader("X-B3-SpanId", String.class);
        String parentSpanId = (String)this.exchange.getIn().getHeader("X-B3-ParentSpanId", String.class);
        if (traceId != null && spanId != null) {
            SpanId span = ZipkinHelper.createSpanId(traceId, spanId, parentSpanId);
            return TraceData.builder().sample(Boolean.valueOf(true)).spanId(span).build();
        }
        return TraceData.builder().build();
    }

    public String getSpanName() {
        return this.spanName;
    }

    public Collection<KeyValueAnnotation> requestAnnotations() {
        KeyValueAnnotation key1 = KeyValueAnnotation.create((String)"camel.server.endpoint.url", (String)this.url);
        KeyValueAnnotation key2 = KeyValueAnnotation.create((String)"camel.server.exchange.id", (String)this.exchange.getExchangeId());
        KeyValueAnnotation key3 = KeyValueAnnotation.create((String)"camel.server.exchange.pattern", (String)this.exchange.getPattern().name());
        KeyValueAnnotation key4 = null;
        if (this.eventNotifier.isIncludeMessageBody() || this.eventNotifier.isIncludeMessageBodyStreams()) {
            boolean streams = this.eventNotifier.isIncludeMessageBodyStreams();
            StreamCache cache = ZipkinHelper.prepareBodyForLogging(this.exchange, streams);
            String body = MessageHelper.extractBodyForLogging((Message)(this.exchange.hasOut() ? this.exchange.getOut() : this.exchange.getIn()), (String)"", (boolean)streams, (boolean)streams);
            key4 = KeyValueAnnotation.create((String)"camel.server.exchange.message.request.body", (String)body);
            if (cache != null) {
                cache.reset();
            }
        }
        ArrayList<KeyValueAnnotation> list = new ArrayList<KeyValueAnnotation>();
        list.add(key1);
        list.add(key2);
        list.add(key3);
        if (key4 != null) {
            list.add(key4);
        }
        return list;
    }
}

