/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.zipkin;

import com.github.kristofa.brave.KeyValueAnnotation;
import com.github.kristofa.brave.ServerResponseAdapter;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.zipkin.ZipkinHelper;
import org.apache.camel.zipkin.ZipkinTracer;

public class ZipkinServerResponseAdapter
implements ServerResponseAdapter {
    private final ZipkinTracer eventNotifier;
    private final Exchange exchange;
    private final Endpoint endpoint;
    private final String url;

    public ZipkinServerResponseAdapter(ZipkinTracer eventNotifier, Exchange exchange) {
        this.eventNotifier = eventNotifier;
        this.exchange = exchange;
        this.endpoint = exchange.getFromEndpoint();
        this.url = URISupport.sanitizeUri((String)this.endpoint.getEndpointUri());
    }

    public Collection<KeyValueAnnotation> responseAnnotations() {
        String responseCode;
        String id = this.exchange.getExchangeId();
        String mep = this.exchange.getPattern().name();
        KeyValueAnnotation key1 = KeyValueAnnotation.create((String)"camel.server.endpoint.url", (String)this.url);
        KeyValueAnnotation key2 = KeyValueAnnotation.create((String)"camel.server.exchange.id", (String)id);
        KeyValueAnnotation key3 = KeyValueAnnotation.create((String)"camel.server.exchange.pattern", (String)mep);
        KeyValueAnnotation key4 = null;
        if (this.exchange.getException() != null) {
            String message = this.exchange.getException().getMessage();
            key4 = KeyValueAnnotation.create((String)"camel.server.exchange.failure", (String)message);
        } else if (this.eventNotifier.isIncludeMessageBody() || this.eventNotifier.isIncludeMessageBodyStreams()) {
            boolean streams = this.eventNotifier.isIncludeMessageBodyStreams();
            StreamCache cache = ZipkinHelper.prepareBodyForLogging(this.exchange, streams);
            String body = MessageHelper.extractBodyForLogging((Message)(this.exchange.hasOut() ? this.exchange.getOut() : this.exchange.getIn()), (String)"", (boolean)streams, (boolean)streams);
            key4 = KeyValueAnnotation.create((String)"camel.server.exchange.message.response.body", (String)body);
            if (cache != null) {
                cache.reset();
            }
        }
        KeyValueAnnotation key5 = null;
        String string = responseCode = this.exchange.hasOut() ? (String)this.exchange.getOut().getHeader("CamelHttpResponseCode", String.class) : (String)this.exchange.getIn().getHeader("CamelHttpResponseCode", String.class);
        if (responseCode != null) {
            key5 = KeyValueAnnotation.create((String)"camel.server.exchange.message.response.code", (String)responseCode);
        }
        ArrayList<KeyValueAnnotation> list = new ArrayList<KeyValueAnnotation>();
        list.add(key1);
        list.add(key2);
        list.add(key3);
        if (key4 != null) {
            list.add(key4);
        }
        if (key5 != null) {
            list.add(key5);
        }
        return list;
    }
}

