/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.zipkin;

import brave.SpanCustomizer;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.zipkin.ZipkinHelper;
import org.apache.camel.zipkin.ZipkinTracer;

final class ZipkinClientRequestAdapter {
    private final ZipkinTracer eventNotifier;
    private final String spanName;
    private final String url;

    ZipkinClientRequestAdapter(ZipkinTracer eventNotifier, Endpoint endpoint) {
        this.eventNotifier = eventNotifier;
        this.spanName = URISupport.sanitizeUri((String)endpoint.getEndpointKey()).toLowerCase(Locale.ROOT);
        this.url = URISupport.sanitizeUri((String)endpoint.getEndpointUri());
    }

    void onRequest(Exchange exchange, SpanCustomizer span) {
        span.name(this.spanName);
        span.tag("camel.client.endpoint.url", this.url);
        span.tag("camel.client.exchange.id", exchange.getExchangeId());
        span.tag("camel.client.exchange.pattern", exchange.getPattern().name());
        if (this.eventNotifier.isIncludeMessageBody() || this.eventNotifier.isIncludeMessageBodyStreams()) {
            boolean streams = this.eventNotifier.isIncludeMessageBodyStreams();
            StreamCache cache = ZipkinHelper.prepareBodyForLogging(exchange, streams);
            String body = MessageHelper.extractBodyForLogging((Message)exchange.getMessage(), (String)"", (boolean)streams, (boolean)streams);
            span.tag("camel.client.exchange.message.request.body", body);
            if (cache != null) {
                cache.reset();
            }
        }
        this.eventNotifier.getClientCustomTags().forEach((key, value) -> span.tag("custom." + key, value));
        Map customTags = (Map)exchange.getProperty("camel.client.customtags", Map.class);
        if (customTags != null && !customTags.isEmpty()) {
            for (Map.Entry tag : customTags.entrySet()) {
                span.tag("custom." + (String)tag.getKey(), (String)tag.getValue());
            }
        }
    }
}

