/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.zipkin;

import brave.Span;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;

public final class ZipkinState {
    public static final String KEY = "CamelZipkinState";
    private final Deque<Span> clientSpans = new ConcurrentLinkedDeque<Span>();
    private final Deque<Span> serverSpans = new ConcurrentLinkedDeque<Span>();

    public static ZipkinState fromZipkinState(ZipkinState fromState) {
        ZipkinState state = new ZipkinState();
        state.clientSpans.addAll(fromState.clientSpans);
        state.serverSpans.addAll(fromState.serverSpans);
        return state;
    }

    public void pushClientSpan(Span span) {
        this.clientSpans.push(span);
    }

    public Span popClientSpan() {
        if (!this.clientSpans.isEmpty()) {
            return this.clientSpans.pop();
        }
        return null;
    }

    public void pushServerSpan(Span span) {
        this.serverSpans.push(span);
    }

    public Span popServerSpan() {
        if (!this.serverSpans.isEmpty()) {
            return this.serverSpans.pop();
        }
        return null;
    }

    public Span peekServerSpan() {
        if (!this.serverSpans.isEmpty()) {
            return this.serverSpans.peek();
        }
        return null;
    }
}

