/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeepermaster.group.internal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.camel.component.zookeepermaster.group.Group;
import org.apache.camel.component.zookeepermaster.group.GroupListener;
import org.apache.camel.component.zookeepermaster.group.NodeState;
import org.apache.camel.component.zookeepermaster.group.internal.ChildData;
import org.apache.camel.component.zookeepermaster.group.internal.CompositeOperation;
import org.apache.camel.component.zookeepermaster.group.internal.EventOperation;
import org.apache.camel.component.zookeepermaster.group.internal.GetDataOperation;
import org.apache.camel.component.zookeepermaster.group.internal.Operation;
import org.apache.camel.component.zookeepermaster.group.internal.RefreshOperation;
import org.apache.camel.component.zookeepermaster.group.internal.SequenceComparator;
import org.apache.camel.component.zookeepermaster.group.internal.UpdateOperation;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.listen.ListenerContainer;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.utils.EnsurePath;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperGroup<T extends NodeState>
implements Group<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperGroup.class);
    private static ObjectMapper mapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final Class<T> clazz;
    private final CuratorFramework client;
    private final String path;
    private final ExecutorService executorService;
    private final EnsurePath ensurePath;
    private final BlockingQueue<Operation> operations = new LinkedBlockingQueue<Operation>();
    private final ListenerContainer<GroupListener<T>> listeners = new ListenerContainer();
    private final ConcurrentMap<String, ChildData<T>> currentData = new ConcurrentHashMap<String, ChildData<T>>();
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean connected = new AtomicBoolean();
    private final SequenceComparator sequenceComparator = new SequenceComparator();
    private final String uuid = UUID.randomUUID().toString();
    private volatile String id;
    private final AtomicBoolean creating = new AtomicBoolean();
    private final AtomicBoolean unstable = new AtomicBoolean();
    private volatile T state;
    private final Watcher childrenWatcher = new Watcher(){

        public void process(WatchedEvent event) {
            if (event.getType() != Watcher.Event.EventType.None) {
                ZooKeeperGroup.this.offerOperation(new RefreshOperation(ZooKeeperGroup.this, RefreshMode.STANDARD));
            }
        }
    };
    private final Watcher dataWatcher = new Watcher(){

        public void process(WatchedEvent event) {
            try {
                if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
                    ZooKeeperGroup.this.remove(event.getPath());
                } else if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                    ZooKeeperGroup.this.offerOperation(new GetDataOperation(ZooKeeperGroup.this, event.getPath()));
                }
            }
            catch (Exception e) {
                ZooKeeperGroup.this.handleException(e);
            }
        }
    };
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            ZooKeeperGroup.this.handleStateChange(newState);
        }
    };

    public ZooKeeperGroup(CuratorFramework client, String path, Class<T> clazz) {
        this(client, path, clazz, Executors.newSingleThreadExecutor());
    }

    public ZooKeeperGroup(CuratorFramework client, String path, Class<T> clazz, ThreadFactory threadFactory) {
        this(client, path, clazz, Executors.newSingleThreadExecutor(threadFactory));
    }

    public ZooKeeperGroup(CuratorFramework client, String path, Class<T> clazz, ExecutorService executorService) {
        LOG.info("Creating ZK Group for path \"{}\"", (Object)path);
        this.client = client;
        this.path = path;
        this.clazz = clazz;
        this.executorService = executorService;
        this.ensurePath = client.newNamespaceAwareEnsurePath(path);
    }

    @Override
    public void start() {
        LOG.info("Starting ZK Group for path: {}", (Object)this.path);
        if (this.started.compareAndSet(false, true)) {
            this.connected.set(this.client.getZookeeperClient().isConnected());
            if (this.isConnected()) {
                this.handleStateChange(ConnectionState.CONNECTED);
            }
            this.client.getConnectionStateListenable().addListener((Object)this.connectionStateListener);
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    ZooKeeperGroup.this.mainLoop();
                }
            });
        }
    }

    @Override
    public void close() throws IOException {
        LOG.debug("{}.close, connected:{}", (Object)this, (Object)this.connected);
        if (this.started.compareAndSet(true, false)) {
            this.client.getConnectionStateListenable().removeListener((Object)this.connectionStateListener);
            this.executorService.shutdownNow();
            try {
                this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
            try {
                this.doUpdate(null);
                if (this.isConnected()) {
                    this.callListeners(GroupListener.GroupEvent.DISCONNECTED);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
            this.listeners.clear();
            mapper.getTypeFactory().clearCache();
            mapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            this.client.clearWatcherReferences(this.childrenWatcher);
            this.client.clearWatcherReferences(this.dataWatcher);
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public void add(GroupListener<T> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void remove(GroupListener<T> listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public void update(T state) {
        T oldState = this.state;
        this.state = state;
        if (this.started.get()) {
            boolean update;
            boolean bl = update = state == null && oldState != null || state != null && oldState == null || !Arrays.equals(this.encode(state), this.encode(oldState));
            if (update) {
                this.offerOperation(new CompositeOperation(new RefreshOperation(this, RefreshMode.FORCE_GET_DATA_AND_STAT), new UpdateOperation<T>(this, state)));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doUpdate(T state) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} doUpdate, state:{} id:{}", new Object[]{this, state, this.id});
        }
        if (state == null) {
            if (this.id != null) {
                try {
                    if (!this.isConnected()) return;
                    ((ChildrenDeletable)this.client.delete().guaranteed()).forPath(this.id);
                    this.unstable.set(false);
                    return;
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    return;
                }
                finally {
                    this.id = null;
                }
            } else {
                if (!this.creating.get()) return;
                LOG.warn("Ephemeral node could be created in the registry, but ZooKeeper group didn't record its id");
                this.unstable.set(true);
            }
            return;
        }
        if (!this.isConnected()) return;
        if (this.id == null) {
            this.id = this.createEphemeralNode(state);
            return;
        }
        try {
            this.updateEphemeralNode(state);
            return;
        }
        catch (KeeperException.NoNodeException e) {
            this.id = this.createEphemeralNode(state);
        }
    }

    private String createEphemeralNode(T state) throws Exception {
        ((NodeState)state).uuid = this.uuid;
        this.creating.set(true);
        String pathId = (String)((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(this.path + "/0", this.encode(state));
        this.creating.set(false);
        this.unstable.set(false);
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}, state:{}, new ephemeralSequential path:{}", new Object[]{this, state, pathId});
        }
        this.prunePartialState(state, pathId);
        ((NodeState)state).uuid = null;
        return pathId;
    }

    private void updateEphemeralNode(T state) throws Exception {
        ((NodeState)state).uuid = this.uuid;
        this.client.setData().forPath(this.id, this.encode(state));
        ((NodeState)state).uuid = null;
    }

    private void prunePartialState(T ourState, String pathId) throws Exception {
        if (((NodeState)ourState).uuid != null) {
            this.clearAndRefresh(true, true);
            ArrayList children = new ArrayList(this.currentData.values());
            for (ChildData child : children) {
                if (!((NodeState)ourState).uuid.equals(((NodeState)child.getNode()).uuid) || child.getPath().equals(pathId)) continue;
                LOG.debug("Deleting partially created znode: {}", (Object)child.getPath());
                ((ChildrenDeletable)this.client.delete().guaranteed()).forPath(child.getPath());
            }
        }
    }

    @Override
    public Map<String, T> members() {
        List<ChildData<T>> children = this.getActiveChildren();
        Collections.sort(children, this.sequenceComparator);
        LinkedHashMap<String, T> members = new LinkedHashMap<String, T>();
        for (ChildData<T> child : children) {
            members.put(child.getPath(), child.getNode());
        }
        return members;
    }

    @Override
    public boolean isMaster() {
        List<ChildData<T>> children = this.getActiveChildren();
        Collections.sort(children, this.sequenceComparator);
        return !children.isEmpty() && children.get(0).getPath().equals(this.id);
    }

    @Override
    public T master() {
        List<ChildData<T>> children = this.getActiveChildren();
        Collections.sort(children, this.sequenceComparator);
        if (children.isEmpty()) {
            return null;
        }
        return (T)((NodeState)children.get(0).getNode());
    }

    @Override
    public List<T> slaves() {
        List<ChildData<T>> children = this.getActiveChildren();
        Collections.sort(children, this.sequenceComparator);
        ArrayList<T> slaves = new ArrayList<T>();
        for (int i = 1; i < children.size(); ++i) {
            slaves.add(children.get(i).getNode());
        }
        return slaves;
    }

    protected List<ChildData<T>> getActiveChildren() {
        HashMap<String, ChildData> filtered = new HashMap<String, ChildData>();
        for (ChildData child : this.currentData.values()) {
            NodeState node = (NodeState)child.getNode();
            if (filtered.containsKey(node.getContainer()) && ((ChildData)filtered.get(node.getContainer())).getPath().compareTo(child.getPath()) >= 0) continue;
            filtered.put(node.getContainer(), child);
        }
        return new ArrayList<ChildData<T>>(filtered.values());
    }

    @Override
    public T getLastState() {
        return this.state;
    }

    public SequenceComparator getSequenceComparator() {
        return this.sequenceComparator;
    }

    public ListenerContainer<GroupListener<T>> getListenable() {
        return this.listeners;
    }

    public List<ChildData> getCurrentData() {
        ArrayList<ChildData> answer = new ArrayList<ChildData>();
        answer.addAll(this.currentData.values());
        return answer;
    }

    void putCurrentData(String key, ChildData value) {
        this.currentData.put(key, value);
    }

    public ChildData getCurrentData(String fullPath) {
        return (ChildData)this.currentData.get(fullPath);
    }

    public void clearAndRefresh() throws Exception {
        this.clearAndRefresh(false, false);
    }

    public void clearAndRefresh(boolean force, boolean sync) throws Exception {
        RefreshMode mode = force ? RefreshMode.FORCE_GET_DATA_AND_STAT : RefreshMode.STANDARD;
        this.currentData.clear();
        if (sync) {
            this.refresh(mode);
        } else {
            this.offerOperation(new RefreshOperation(this, mode));
        }
    }

    public void clear() {
        this.currentData.clear();
    }

    void refresh(RefreshMode mode) throws Exception {
        try {
            this.ensurePath.ensure(this.client.getZookeeperClient());
            List children = (List)((BackgroundPathable)this.client.getChildren().usingWatcher(this.childrenWatcher)).forPath(this.path);
            Collections.sort(children, new Comparator<String>(){

                @Override
                public int compare(String left, String right) {
                    return left.compareTo(right);
                }
            });
            this.processChildren(children, mode);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    void callListeners(GroupListener.GroupEvent event) {
        this.listeners.forEach(listener -> {
            try {
                listener.groupEvent(this, event);
            }
            catch (Exception e) {
                this.handleException(e);
            }
            return null;
        });
    }

    void getDataAndStat(String fullPath) throws Exception {
        Stat stat = new Stat();
        byte[] data = (byte[])((Pathable)((WatchPathable)this.client.getData().storingStatIn(stat)).usingWatcher(this.dataWatcher)).forPath(fullPath);
        this.applyNewData(fullPath, KeeperException.Code.OK.intValue(), stat, data);
    }

    protected void handleException(Throwable e) {
        if (e instanceof IllegalStateException && "Client is not started".equals(e.getMessage())) {
            LOG.debug("", e);
        } else {
            LOG.error("", e);
        }
    }

    protected void remove(String fullPath) {
        ChildData data = (ChildData)this.currentData.remove(fullPath);
        if (data != null) {
            this.offerOperation(new EventOperation(this, GroupListener.GroupEvent.CHANGED));
        }
    }

    private void handleStateChange(ConnectionState newState) {
        switch (newState) {
            case SUSPENDED: 
            case LOST: {
                this.connected.set(false);
                this.clear();
                EventOperation op = new EventOperation(this, GroupListener.GroupEvent.DISCONNECTED);
                op.invoke();
                break;
            }
            case CONNECTED: 
            case RECONNECTED: {
                this.connected.set(true);
                this.offerOperation(new CompositeOperation(new RefreshOperation(this, RefreshMode.FORCE_GET_DATA_AND_STAT), new UpdateOperation<T>(this, this.state), new EventOperation(this, GroupListener.GroupEvent.CONNECTED)));
                break;
            }
        }
    }

    private void processChildren(List<String> children, RefreshMode mode) throws Exception {
        List fullPaths = children.stream().map(c -> ZKPaths.makePath((String)this.path, (String)c)).collect(Collectors.toList());
        HashSet removedNodes = new HashSet(this.currentData.keySet());
        removedNodes.removeAll(fullPaths);
        for (String fullPath : removedNodes) {
            this.remove(fullPath);
        }
        for (String name : children) {
            String fullPath = ZKPaths.makePath((String)this.path, (String)name);
            if (mode != RefreshMode.FORCE_GET_DATA_AND_STAT && this.currentData.containsKey(fullPath)) continue;
            try {
                this.getDataAndStat(fullPath);
            }
            catch (KeeperException.NoNodeException noNodeException) {}
        }
    }

    private void applyNewData(String fullPath, int resultCode, Stat stat, byte[] bytes) {
        ChildData<T> data;
        ChildData<T> previousData;
        if (resultCode == KeeperException.Code.OK.intValue() && ((previousData = this.currentData.put(fullPath, data = new ChildData<T>(fullPath, stat, bytes, this.decode(bytes)))) == null || previousData.getStat().getVersion() != stat.getVersion())) {
            this.offerOperation(new EventOperation(this, GroupListener.GroupEvent.CHANGED));
        }
    }

    private void mainLoop() {
        while (this.started.get() && !Thread.currentThread().isInterrupted()) {
            try {
                this.operations.take().invoke();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private byte[] encode(T state) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            mapper.writeValue((OutputStream)baos, state);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to decode data", e);
        }
    }

    private T decode(byte[] data) {
        try {
            return (T)((NodeState)mapper.readValue(data, this.clazz));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to decode data", e);
        }
    }

    private void offerOperation(Operation operation) {
        if (!this.operations.contains(operation)) {
            this.operations.offer(operation);
        }
    }

    public static <T> Map<String, T> members(ObjectMapper mapper, CuratorFramework curator, String path, Class<T> clazz) throws Exception {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        List nodes = (List)curator.getChildren().forPath(path);
        for (String node : nodes) {
            byte[] data = (byte[])curator.getData().forPath(path + "/" + node);
            Object val = mapper.readValue(data, clazz);
            map.put(node, val);
        }
        return map;
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public boolean isUnstable() {
        return this.unstable.get();
    }

    static enum RefreshMode {
        STANDARD,
        FORCE_GET_DATA_AND_STAT;

    }
}

