/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeepermaster;

import org.apache.camel.Endpoint;
import org.apache.camel.component.zookeepermaster.CamelNodeState;
import org.apache.camel.component.zookeepermaster.ZookeeperGroupSupport;
import org.apache.camel.component.zookeepermaster.group.Group;
import org.apache.camel.component.zookeepermaster.group.GroupListener;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperGroupListenerSupport
extends ZookeeperGroupSupport
implements GroupListener {
    private static final transient Logger LOG = LoggerFactory.getLogger(ZookeeperGroupListenerSupport.class);
    private Group<CamelNodeState> singleton;
    private final String clusterPath;
    private final Endpoint endpoint;
    private final Runnable onLockAcquired;
    private final Runnable onDisconnected;

    public ZookeeperGroupListenerSupport(String clusterPath, Endpoint endpoint, Runnable onLockAcquired, Runnable onDisconnected) {
        this.clusterPath = clusterPath;
        this.endpoint = endpoint;
        this.onLockAcquired = onLockAcquired;
        this.onDisconnected = onDisconnected;
    }

    public void updateState(CamelNodeState state) {
        this.singleton.update(state);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.singleton = this.createGroup(this.clusterPath);
        this.singleton.add(this);
        this.singleton.start();
    }

    @Override
    protected void doStop() throws Exception {
        IOHelper.close(this.singleton);
        super.doStop();
    }

    public String getClusterPath() {
        return this.clusterPath;
    }

    public Group<CamelNodeState> getGroup() {
        return this.singleton;
    }

    public void groupEvent(Group group, GroupListener.GroupEvent event) {
        switch (event) {
            case CONNECTED: {
                break;
            }
            case CHANGED: {
                if (!this.singleton.isConnected()) break;
                if (this.singleton.isMaster()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Master/Standby endpoint is Master for: {} in {}", (Object)this.endpoint, (Object)this.endpoint.getCamelContext());
                    }
                    this.onLockOwned();
                    break;
                }
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Master/Standby endpoint is Standby for: {} in {}", (Object)this.endpoint, (Object)this.endpoint.getCamelContext());
                break;
            }
            case DISCONNECTED: {
                try {
                    LOG.info("Disconnecting as master. Stopping consumer: {}", (Object)this.endpoint);
                    this.onDisconnected();
                }
                catch (Exception e) {
                    LOG.warn("Failed to stop master consumer for: {}. This exception is ignored.", (Object)this.endpoint, (Object)e);
                }
                break;
            }
        }
    }

    protected void onDisconnected() {
        this.onDisconnected.run();
    }

    protected void onLockOwned() {
        this.onLockAcquired.run();
    }
}

