/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.nio.file.Paths;
import javax.lang.model.element.Modifier;
import org.apache.camel.k.tooling.maven.GenerateYamlSupport;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;

@Mojo(name="generate-yaml-loader-support-classes", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true, requiresProject=false)
public class GenerateYamlLoaderSupportClasses
extends GenerateYamlSupport {
    public void execute() throws MojoFailureException {
        try {
            JavaFile.builder((String)"org.apache.camel.k.loader.yaml", (TypeSpec)this.generateJacksonModule()).indent("    ").build().writeTo(Paths.get(this.output, new String[0]));
            JavaFile.builder((String)"org.apache.camel.k.loader.yaml", (TypeSpec)this.generateReifiers()).indent("    ").build().writeTo(Paths.get(this.output, new String[0]));
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    public final TypeSpec generateJacksonModule() {
        TypeSpec.Builder type = TypeSpec.classBuilder((String)"YamlModule");
        type.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        type.superclass(Module.class);
        type.addMethod(MethodSpec.methodBuilder((String)"getModuleName").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addCode(CodeBlock.builder().addStatement("return $S", new Object[]{"camel-yaml"}).build()).build());
        type.addMethod(MethodSpec.methodBuilder((String)"version").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Version.class).addCode(CodeBlock.builder().addStatement("return $L", new Object[]{"Version.unknownVersion()"}).build()).build());
        MethodSpec.Builder mb = MethodSpec.methodBuilder((String)"setupModule").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Module.SetupContext.class, "context", new Modifier[0]);
        this.definitions(EXPRESSION_DEFINITION_CLASS).forEach((k, v) -> mb.addStatement("context.registerSubtypes(new com.fasterxml.jackson.databind.jsontype.NamedType($T.class, $S))", new Object[]{v, k}));
        this.definitions(DATAFORMAT_DEFINITION_CLASS).forEach((k, v) -> mb.addStatement("context.registerSubtypes(new com.fasterxml.jackson.databind.jsontype.NamedType($T.class, $S))", new Object[]{v, k}));
        type.addMethod(mb.build());
        return type.build();
    }

    public final TypeSpec generateReifiers() {
        TypeSpec.Builder type = TypeSpec.classBuilder((String)"YamlReifiers");
        type.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        MethodSpec.Builder mb = MethodSpec.methodBuilder((String)"registerReifiers").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC});
        this.annotated(YAML_STEP_DEFINITION_ANNOTATION).forEach(i -> {
            AnnotationInstance annotation = i.classAnnotation(YAML_STEP_DEFINITION_ANNOTATION);
            AnnotationValue reifiers = annotation.value("reifiers");
            String name = i.toString();
            if (i.nestingType() == ClassInfo.NestingType.INNER) {
                name = i.enclosingClass().toString() + "." + i.simpleName();
            }
            if (reifiers != null) {
                for (String reifier : reifiers.asStringArray()) {
                    mb.addStatement("org.apache.camel.reifier.ProcessorReifier.registerReifier($L.class, $L::new);", new Object[]{name, reifier});
                }
            }
        });
        type.addMethod(mb.build());
        return type.build();
    }
}

