/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model.crd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.k.tooling.maven.model.CamelArtifact;
import org.apache.camel.k.tooling.maven.model.CamelLoader;
import org.apache.camel.k.tooling.maven.model.crd.CamelCatalogSpec;
import org.apache.camel.k.tooling.maven.model.crd.RuntimeSpec;
import org.immutables.value.Generated;

@Generated(from="CamelCatalogSpec", generator="Immutables")
public final class ImmutableCamelCatalogSpec
implements CamelCatalogSpec {
    private final RuntimeSpec runtime;
    private final ImmutableMap<String, CamelArtifact> artifacts;
    private final ImmutableMap<String, CamelLoader> loaders;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCamelCatalogSpec(Builder builder) {
        this.runtime = builder.runtime;
        if (builder.artifactsIsSet()) {
            this.initShim.artifacts((ImmutableMap<String, CamelArtifact>)builder.artifacts.build());
        }
        if (builder.loadersIsSet()) {
            this.initShim.loaders((ImmutableMap<String, CamelLoader>)builder.loaders.build());
        }
        this.artifacts = this.initShim.getArtifacts();
        this.loaders = this.initShim.getLoaders();
        this.initShim = null;
    }

    private ImmutableCamelCatalogSpec(RuntimeSpec runtime, ImmutableMap<String, CamelArtifact> artifacts, ImmutableMap<String, CamelLoader> loaders) {
        this.runtime = runtime;
        this.artifacts = artifacts;
        this.loaders = loaders;
        this.initShim = null;
    }

    private Map<String, CamelArtifact> getArtifactsInitialize() {
        return CamelCatalogSpec.super.getArtifacts();
    }

    private Map<String, CamelLoader> getLoadersInitialize() {
        return CamelCatalogSpec.super.getLoaders();
    }

    @Override
    @JsonProperty(value="runtime")
    public RuntimeSpec getRuntime() {
        return this.runtime;
    }

    @JsonProperty(value="artifacts")
    public ImmutableMap<String, CamelArtifact> getArtifacts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getArtifacts() : this.artifacts;
    }

    @JsonProperty(value="loaders")
    public ImmutableMap<String, CamelLoader> getLoaders() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLoaders() : this.loaders;
    }

    public final ImmutableCamelCatalogSpec withRuntime(RuntimeSpec value) {
        if (this.runtime == value) {
            return this;
        }
        RuntimeSpec newValue = Objects.requireNonNull(value, "runtime");
        return new ImmutableCamelCatalogSpec(newValue, this.artifacts, this.loaders);
    }

    public final ImmutableCamelCatalogSpec withArtifacts(Map<String, ? extends CamelArtifact> entries) {
        if (this.artifacts == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCamelCatalogSpec(this.runtime, (ImmutableMap<String, CamelArtifact>)newValue, this.loaders);
    }

    public final ImmutableCamelCatalogSpec withLoaders(Map<String, ? extends CamelLoader> entries) {
        if (this.loaders == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCamelCatalogSpec(this.runtime, this.artifacts, (ImmutableMap<String, CamelLoader>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCamelCatalogSpec && this.equalTo((ImmutableCamelCatalogSpec)another);
    }

    private boolean equalTo(ImmutableCamelCatalogSpec another) {
        return this.runtime.equals(another.runtime) && this.artifacts.equals(another.artifacts) && this.loaders.equals(another.loaders);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.runtime.hashCode();
        h += (h << 5) + this.artifacts.hashCode();
        h += (h << 5) + this.loaders.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CamelCatalogSpec").omitNullValues().add("runtime", (Object)this.runtime).add("artifacts", this.artifacts).add("loaders", this.loaders).toString();
    }

    public static ImmutableCamelCatalogSpec copyOf(CamelCatalogSpec instance) {
        if (instance instanceof ImmutableCamelCatalogSpec) {
            return (ImmutableCamelCatalogSpec)instance;
        }
        return new CamelCatalogSpec.Builder().from(instance).build();
    }

    @JsonPropertyOrder(value={"runtime", "artifacts"})
    @Generated(from="CamelCatalogSpec", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_RUNTIME = 1L;
        private static final long OPT_BIT_ARTIFACTS = 1L;
        private static final long OPT_BIT_LOADERS = 2L;
        private long initBits = 1L;
        private long optBits;
        private RuntimeSpec runtime;
        private ImmutableMap.Builder<String, CamelArtifact> artifacts = ImmutableMap.builder();
        private ImmutableMap.Builder<String, CamelLoader> loaders = ImmutableMap.builder();

        public Builder() {
            if (!(this instanceof CamelCatalogSpec.Builder)) {
                throw new UnsupportedOperationException("Use: new CamelCatalogSpec.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final CamelCatalogSpec.Builder from(CamelCatalogSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.runtime(instance.getRuntime());
            this.putAllArtifacts(instance.getArtifacts());
            this.putAllLoaders(instance.getLoaders());
            return (CamelCatalogSpec.Builder)this;
        }

        @JsonProperty(value="runtime")
        @CanIgnoreReturnValue
        public final CamelCatalogSpec.Builder runtime(RuntimeSpec runtime) {
            this.runtime = Objects.requireNonNull(runtime, "runtime");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (CamelCatalogSpec.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelCatalogSpec.Builder putArtifact(String key, CamelArtifact value) {
            this.artifacts.put((Object)key, (Object)value);
            this.optBits |= 1L;
            return (CamelCatalogSpec.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelCatalogSpec.Builder putArtifact(Map.Entry<String, ? extends CamelArtifact> entry) {
            this.artifacts.put(entry);
            this.optBits |= 1L;
            return (CamelCatalogSpec.Builder)this;
        }

        @JsonProperty(value="artifacts")
        @CanIgnoreReturnValue
        public final CamelCatalogSpec.Builder artifacts(Map<String, ? extends CamelArtifact> entries) {
            this.artifacts = ImmutableMap.builder();
            this.optBits |= 1L;
            return this.putAllArtifacts(entries);
        }

        @CanIgnoreReturnValue
        public final CamelCatalogSpec.Builder putAllArtifacts(Map<String, ? extends CamelArtifact> entries) {
            this.artifacts.putAll(entries);
            this.optBits |= 1L;
            return (CamelCatalogSpec.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelCatalogSpec.Builder putLoader(String key, CamelLoader value) {
            this.loaders.put((Object)key, (Object)value);
            this.optBits |= 2L;
            return (CamelCatalogSpec.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CamelCatalogSpec.Builder putLoader(Map.Entry<String, ? extends CamelLoader> entry) {
            this.loaders.put(entry);
            this.optBits |= 2L;
            return (CamelCatalogSpec.Builder)this;
        }

        @JsonProperty(value="loaders")
        @CanIgnoreReturnValue
        public final CamelCatalogSpec.Builder loaders(Map<String, ? extends CamelLoader> entries) {
            this.loaders = ImmutableMap.builder();
            this.optBits |= 2L;
            return this.putAllLoaders(entries);
        }

        @CanIgnoreReturnValue
        public final CamelCatalogSpec.Builder putAllLoaders(Map<String, ? extends CamelLoader> entries) {
            this.loaders.putAll(entries);
            this.optBits |= 2L;
            return (CamelCatalogSpec.Builder)this;
        }

        public ImmutableCamelCatalogSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCamelCatalogSpec(this);
        }

        private boolean artifactsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean loadersIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("runtime");
            }
            return "Cannot build CamelCatalogSpec, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="CamelCatalogSpec", generator="Immutables")
    private final class InitShim {
        private byte artifactsBuildStage = 0;
        private ImmutableMap<String, CamelArtifact> artifacts;
        private byte loadersBuildStage = 0;
        private ImmutableMap<String, CamelLoader> loaders;

        private InitShim() {
        }

        ImmutableMap<String, CamelArtifact> getArtifacts() {
            if (this.artifactsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.artifactsBuildStage == 0) {
                this.artifactsBuildStage = (byte)-1;
                this.artifacts = ImmutableMap.copyOf((Map)ImmutableCamelCatalogSpec.this.getArtifactsInitialize());
                this.artifactsBuildStage = 1;
            }
            return this.artifacts;
        }

        void artifacts(ImmutableMap<String, CamelArtifact> artifacts) {
            this.artifacts = artifacts;
            this.artifactsBuildStage = 1;
        }

        ImmutableMap<String, CamelLoader> getLoaders() {
            if (this.loadersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.loadersBuildStage == 0) {
                this.loadersBuildStage = (byte)-1;
                this.loaders = ImmutableMap.copyOf((Map)ImmutableCamelCatalogSpec.this.getLoadersInitialize());
                this.loadersBuildStage = 1;
            }
            return this.loaders;
        }

        void loaders(ImmutableMap<String, CamelLoader> loaders) {
            this.loaders = loaders;
            this.loadersBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.artifactsBuildStage == -1) {
                attributes.add("artifacts");
            }
            if (this.loadersBuildStage == -1) {
                attributes.add("loaders");
            }
            return "Cannot build CamelCatalogSpec, attribute initializers form cycle " + attributes;
        }
    }
}

