/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model.crd;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.Map;
import org.apache.camel.k.tooling.maven.model.CamelArtifact;
import org.apache.camel.k.tooling.maven.model.CamelLoader;
import org.apache.camel.k.tooling.maven.model.crd.ImmutableCamelCatalogSpec;
import org.apache.camel.k.tooling.maven.model.crd.RuntimeSpec;
import org.immutables.value.Value;

@JsonDeserialize(builder=Builder.class)
@JsonPropertyOrder(value={"runtime", "artifacts"})
@Value.Immutable
@Value.Style(depluralize=true)
public interface CamelCatalogSpec {
    public RuntimeSpec getRuntime();

    @Value.Default
    default public Map<String, CamelArtifact> getArtifacts() {
        return Collections.emptyMap();
    }

    @Value.Default
    default public Map<String, CamelLoader> getLoaders() {
        return Collections.emptyMap();
    }

    public static class Builder
    extends ImmutableCamelCatalogSpec.Builder {
        public Builder putArtifact(CamelArtifact artifact) {
            this.putArtifact(artifact.getArtifactId(), artifact);
            return this;
        }

        public Builder putArtifact(String groupId, String artifactId) {
            this.putArtifact(new CamelArtifact.Builder().groupId(groupId).artifactId(artifactId).build());
            return this;
        }
    }
}

