/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.quarkus;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.runtime.Quarkus;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.k.Runtime;
import org.apache.camel.main.BaseMainSupport;
import org.apache.camel.main.MainListener;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.spi.Resource;

public final class Application {
    private Application() {
    }

    public static Optional<ArcContainer> container() {
        return Optional.of(Arc.container());
    }

    public static <T> Optional<T> instance(Class<T> type) {
        return Application.container().map(container -> container.instance(type, new Annotation[0])).map(InstanceHandle::get);
    }

    public static class NoRoutesCollector
    implements RoutesCollector {
        private boolean ignoreLoadingError;

        public Collection<RoutesBuilder> collectRoutesFromDirectory(CamelContext camelContext, String excludePattern, String includePattern) {
            return Collections.emptyList();
        }

        public Collection<Resource> findRouteResourcesFromDirectory(CamelContext camelContext, String excludePattern, String includePattern) {
            return Collections.emptyList();
        }

        public List<RoutesBuilder> collectRoutesFromRegistry(CamelContext camelContext, String excludePattern, String includePattern) {
            return Collections.emptyList();
        }

        public boolean isIgnoreLoadingError() {
            return this.ignoreLoadingError;
        }

        public void setIgnoreLoadingError(boolean ignoreLoadingError) {
            this.ignoreLoadingError = ignoreLoadingError;
        }
    }

    public static class ListenerAdapter
    implements MainListener {
        private final Runtime.Listener[] listeners;

        public ListenerAdapter(List<Runtime.Listener> listeners) {
            this.listeners = (Runtime.Listener[])listeners.stream().sorted(Comparator.comparingInt(Runtime.Listener::getOrder)).toArray(Runtime.Listener[]::new);
        }

        public void beforeInitialize(BaseMainSupport main) {
            this.invokeListeners(Runtime.Phase.Initializing);
            this.invokeListeners(Runtime.Phase.ConfigureProperties);
        }

        public void beforeConfigure(BaseMainSupport main) {
            this.invokeListeners(Runtime.Phase.ConfigureRoutes);
        }

        public void afterConfigure(BaseMainSupport main) {
            this.invokeListeners(Runtime.Phase.ConfigureContext);
        }

        public void beforeStart(BaseMainSupport main) {
            this.invokeListeners(Runtime.Phase.Starting);
        }

        public void afterStart(BaseMainSupport main) {
            this.invokeListeners(Runtime.Phase.Started);
        }

        public void beforeStop(BaseMainSupport main) {
            this.invokeListeners(Runtime.Phase.Stopping);
        }

        public void afterStop(BaseMainSupport main) {
            this.invokeListeners(Runtime.Phase.Stopped);
        }

        private void invokeListeners(Runtime.Phase phase) {
            org.apache.camel.k.Runtime runtime = Application.instance(org.apache.camel.k.Runtime.class).orElseThrow(() -> new IllegalStateException("Unable to fine a Runtime instance"));
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].accept(phase, runtime);
            }
        }
    }

    public static class Runtime
    implements org.apache.camel.k.Runtime {
        private final BaseMainSupport main;
        private final AtomicBoolean stopped;

        public Runtime(BaseMainSupport main) {
            this.main = main;
            this.main.configure().setAutoConfigurationLogSummary(false);
            this.stopped = new AtomicBoolean();
        }

        public CamelContext getCamelContext() {
            return this.main.getCamelContext();
        }

        public void addRoutes(RoutesBuilder builder) {
            this.main.configure().addRoutesBuilder(builder);
        }

        public void setProperties(Properties properties) {
            this.main.setOverrideProperties(properties);
        }

        public void stop() throws Exception {
            if (!this.stopped.compareAndExchange(false, true)) {
                Quarkus.asyncExit();
            }
        }
    }
}

