/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.kameletstatus;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.apache.camel.v1.kameletstatus.ConditionsBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"lastTransitionTime", "lastUpdateTime", "message", "reason", "status", "type"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Conditions
implements Editable<ConditionsBuilder>,
KubernetesResource {
    @JsonProperty(value="lastTransitionTime")
    @JsonPropertyDescription(value="Last time the condition transitioned from one status to another.")
    @JsonSetter(nulls=Nulls.SKIP)
    private ZonedDateTime lastTransitionTime;
    @JsonProperty(value="lastUpdateTime")
    @JsonPropertyDescription(value="The last time this condition was updated.")
    @JsonSetter(nulls=Nulls.SKIP)
    private ZonedDateTime lastUpdateTime;
    @JsonProperty(value="message")
    @JsonPropertyDescription(value="A human-readable message indicating details about the transition.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String message;
    @JsonProperty(value="reason")
    @JsonPropertyDescription(value="The reason for the condition's last transition.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String reason;
    @JsonProperty(value="status")
    @Required
    @JsonPropertyDescription(value="Status of the condition, one of True, False, Unknown.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String status;
    @JsonProperty(value="type")
    @Required
    @JsonPropertyDescription(value="Type of kamelet condition.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String type;

    public ConditionsBuilder edit() {
        return new ConditionsBuilder(this);
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssVV")
    public ZonedDateTime getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[XXX][VV]")
    public void setLastTransitionTime(ZonedDateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssVV")
    public ZonedDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[XXX][VV]")
    public void setLastUpdateTime(ZonedDateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public String toString() {
        return "Conditions(lastTransitionTime=" + this.getLastTransitionTime() + ", lastUpdateTime=" + this.getLastUpdateTime() + ", message=" + this.getMessage() + ", reason=" + this.getReason() + ", status=" + this.getStatus() + ", type=" + this.getType() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Conditions)) {
            return false;
        }
        Conditions other = (Conditions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ZonedDateTime this$lastTransitionTime = this.getLastTransitionTime();
        ZonedDateTime other$lastTransitionTime = other.getLastTransitionTime();
        if (this$lastTransitionTime == null ? other$lastTransitionTime != null : !((Object)this$lastTransitionTime).equals(other$lastTransitionTime)) {
            return false;
        }
        ZonedDateTime this$lastUpdateTime = this.getLastUpdateTime();
        ZonedDateTime other$lastUpdateTime = other.getLastUpdateTime();
        if (this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Conditions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ZonedDateTime $lastTransitionTime = this.getLastTransitionTime();
        result = result * 59 + ($lastTransitionTime == null ? 43 : ((Object)$lastTransitionTime).hashCode());
        ZonedDateTime $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + ($lastUpdateTime == null ? 43 : ((Object)$lastUpdateTime).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

