/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.kamelets.utils.format.spi.DataTypeConverter;
import org.apache.camel.util.ObjectHelper;

public class DefaultDataTypeConverter
implements DataTypeConverter {
    private final String scheme;
    private final String name;
    private final String mediaType;
    private final Class<?> type;

    public DefaultDataTypeConverter(String scheme, String name, String mediaType, Class<?> type) {
        this.scheme = scheme;
        this.name = name;
        this.mediaType = mediaType;
        this.type = type;
    }

    public DefaultDataTypeConverter(String scheme, String name, Class<?> type) {
        this(scheme, name, "", type);
    }

    public DefaultDataTypeConverter(String name, Class<?> type) {
        this("camel", name, type);
    }

    @Override
    public void convert(Exchange exchange) {
        if (this.type.isInstance(exchange.getMessage().getBody())) {
            return;
        }
        try {
            exchange.getMessage().setBody(exchange.getMessage().getMandatoryBody(this.type));
        }
        catch (InvalidPayloadException e) {
            throw new CamelExecutionException(String.format("Failed to convert exchange body to '%s' content using type %s", this.name, ObjectHelper.name(this.type)), exchange, (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    public Class<?> getType() {
        return this.type;
    }
}

