/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format.converter.avro;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.avro.AvroSchema;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.kamelets.utils.format.MimeType;
import org.apache.camel.kamelets.utils.format.converter.avro.Avro;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="avro-x-struct")
public class AvroStructDataType
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        AvroSchema schema = (AvroSchema)message.getExchange().getProperty("X-Content-Schema", AvroSchema.class);
        if (schema == null) {
            throw new CamelExecutionException("Missing proper avro schema for data type processing", message.getExchange());
        }
        try {
            Object unmarshalled = Avro.MAPPER.reader().forType(JsonNode.class).with((FormatSchema)schema).readValue(this.getBodyAsStream(message));
            message.setBody(unmarshalled);
            message.setHeader("Content-Type", (Object)MimeType.STRUCT.type());
        }
        catch (IOException | InvalidPayloadException e) {
            throw new CamelExecutionException("Failed to apply Avro x-struct data type on exchange", message.getExchange(), e);
        }
    }

    private InputStream getBodyAsStream(Message message) throws InvalidPayloadException {
        InputStream bodyStream = (InputStream)message.getBody(InputStream.class);
        if (bodyStream == null) {
            bodyStream = new ByteArrayInputStream((byte[])message.getMandatoryBody(byte[].class));
        }
        return bodyStream;
    }
}

