/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format.converter.aws2.ddb;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.ddb.Ddb2Operations;
import org.apache.camel.component.jackson.JacksonDataFormat;
import org.apache.camel.kamelets.utils.format.converter.json.Json;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;

@DataTypeTransformer(name="aws2-ddb:application-json")
public class Ddb2JsonInputType
extends Transformer {
    private final JacksonDataFormat dataFormat = new JacksonDataFormat(Json.MAPPER, JsonNode.class);

    public void transform(Message message, DataType fromType, DataType toType) {
        if (message.getHeaders().containsKey("CamelAwsDdbItem") || message.getHeaders().containsKey("CamelAwsDdbKey")) {
            return;
        }
        JsonNode jsonBody = this.getBodyAsJsonNode(message);
        String operation = Optional.ofNullable(jsonBody.get("operation")).map(JsonNode::asText).orElse(Ddb2Operations.PutItem.name());
        if (message.getExchange().hasProperties() && message.getExchange().getProperty("operation", String.class) != null) {
            operation = (String)message.getExchange().getProperty("operation", String.class);
        }
        if (message.getHeaders().containsKey("CamelAwsDdbOperation")) {
            operation = ((Ddb2Operations)message.getHeader("CamelAwsDdbOperation", Ddb2Operations.class)).name();
        }
        JsonNode key = jsonBody.get("key");
        JsonNode item = jsonBody.get("item");
        Map keyProps = key != null ? (Map)this.dataFormat.getObjectMapper().convertValue((Object)key, (TypeReference)new TypeReference<Map<String, Object>>(){}) : (Map)this.dataFormat.getObjectMapper().convertValue((Object)jsonBody, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Map itemProps = item != null ? (Map)this.dataFormat.getObjectMapper().convertValue((Object)item, (TypeReference)new TypeReference<Map<String, Object>>(){}) : keyProps;
        Map<String, AttributeValue> keyMap = this.getAttributeValueMap(keyProps);
        switch (Ddb2Operations.valueOf((String)operation)) {
            case PutItem: {
                message.setHeader("CamelAwsDdbOperation", (Object)Ddb2Operations.PutItem);
                message.setHeader("CamelAwsDdbItem", this.getAttributeValueMap(itemProps));
                this.setHeaderIfNotPresent("CamelAwsDdbReturnValues", ReturnValue.ALL_OLD.toString(), message);
                break;
            }
            case UpdateItem: {
                message.setHeader("CamelAwsDdbOperation", (Object)Ddb2Operations.UpdateItem);
                message.setHeader("CamelAwsDdbKey", keyMap);
                message.setHeader("CamelAwsDdbUpdateValues", this.getAttributeValueUpdateMap(itemProps));
                this.setHeaderIfNotPresent("CamelAwsDdbReturnValues", ReturnValue.ALL_NEW.toString(), message);
                break;
            }
            case DeleteItem: {
                message.setHeader("CamelAwsDdbOperation", (Object)Ddb2Operations.DeleteItem);
                message.setHeader("CamelAwsDdbKey", keyMap);
                this.setHeaderIfNotPresent("CamelAwsDdbReturnValues", ReturnValue.ALL_OLD.toString(), message);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported operation '%s'", operation));
            }
        }
    }

    private JsonNode getBodyAsJsonNode(Message message) {
        try {
            if (message.getBody() instanceof JsonNode) {
                return (JsonNode)message.getMandatoryBody(JsonNode.class);
            }
            return (JsonNode)this.dataFormat.unmarshal(message.getExchange(), (InputStream)message.getMandatoryBody(InputStream.class));
        }
        catch (Exception e) {
            throw new CamelExecutionException("Failed to get mandatory Json node from message body", message.getExchange(), (Throwable)e);
        }
    }

    private void setHeaderIfNotPresent(String headerName, Object value, Message message) {
        message.setHeader(headerName, value);
    }

    private Map<String, AttributeValue> getAttributeValueMap(Map<String, Object> body) {
        LinkedHashMap<String, AttributeValue> attributeValueMap = new LinkedHashMap<String, AttributeValue>();
        for (Map.Entry<String, Object> attribute : body.entrySet()) {
            attributeValueMap.put(attribute.getKey(), Ddb2JsonInputType.getAttributeValue(attribute.getValue()));
        }
        return attributeValueMap;
    }

    private Map<String, AttributeValueUpdate> getAttributeValueUpdateMap(Map<String, Object> body) {
        LinkedHashMap<String, AttributeValueUpdate> attributeValueMap = new LinkedHashMap<String, AttributeValueUpdate>();
        for (Map.Entry<String, Object> attribute : body.entrySet()) {
            attributeValueMap.put(attribute.getKey(), Ddb2JsonInputType.getAttributeValueUpdate(attribute.getValue()));
        }
        return attributeValueMap;
    }

    private static AttributeValue getAttributeValue(Object value) {
        if (value == null) {
            return (AttributeValue)AttributeValue.builder().nul(Boolean.valueOf(true)).build();
        }
        if (value instanceof String) {
            return (AttributeValue)AttributeValue.builder().s(value.toString()).build();
        }
        if (value instanceof Integer) {
            return (AttributeValue)AttributeValue.builder().n(value.toString()).build();
        }
        if (value instanceof Boolean) {
            return (AttributeValue)AttributeValue.builder().bool((Boolean)value).build();
        }
        if (value instanceof String[]) {
            return (AttributeValue)AttributeValue.builder().ss((String[])value).build();
        }
        if (value instanceof int[]) {
            return (AttributeValue)AttributeValue.builder().ns((Collection)Stream.of((int[])value).map(Object::toString).collect(Collectors.toList())).build();
        }
        if (value instanceof List) {
            List values = (List)value;
            if (values.isEmpty()) {
                return (AttributeValue)AttributeValue.builder().ss(new String[0]).build();
            }
            if (values.get(0) instanceof Integer) {
                return (AttributeValue)AttributeValue.builder().ns((Collection)values.stream().map(Object::toString).collect(Collectors.toList())).build();
            }
            return (AttributeValue)AttributeValue.builder().ss((Collection)values.stream().map(Object::toString).collect(Collectors.toList())).build();
        }
        if (value instanceof Map) {
            LinkedHashMap<String, AttributeValue> nestedAttributes = new LinkedHashMap<String, AttributeValue>();
            for (Map.Entry nested : ((Map)value).entrySet()) {
                nestedAttributes.put(nested.getKey().toString(), Ddb2JsonInputType.getAttributeValue(nested.getValue()));
            }
            return (AttributeValue)AttributeValue.builder().m(nestedAttributes).build();
        }
        return (AttributeValue)AttributeValue.builder().s(value.toString()).build();
    }

    private static AttributeValueUpdate getAttributeValueUpdate(Object value) {
        return (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.PUT).value(Ddb2JsonInputType.getAttributeValue(value)).build();
    }
}

