/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format.converter.aws2.s3;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.kamelets.utils.format.converter.utils.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="aws2-s3:application-cloudevents")
public class AWS2S3CloudEventOutputType
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        headers.put("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.put("CamelCloudEventType", "org.apache.camel.event.aws.s3.getObject");
        headers.put("CamelCloudEventSource", "aws.s3.bucket." + (String)message.getHeader("CamelAwsS3BucketName", String.class));
        headers.put("CamelCloudEventSubject", message.getHeader("CamelAwsS3Key", String.class));
        headers.put("CamelCloudEventTime", CloudEvents.getEventTime(message.getExchange()));
    }
}

