/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format.converter.http;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.kamelets.utils.format.converter.utils.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="http:application-cloudevents")
public class HttpCloudEventOutputType
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        headers.put("ce-id", message.getExchange().getExchangeId());
        headers.put("ce-specversion", headers.getOrDefault("CamelCloudEventVersion", "1.0"));
        headers.put("ce-type", headers.getOrDefault("CamelCloudEventType", "org.apache.camel.event"));
        headers.put("ce-source", headers.getOrDefault("CamelCloudEventSource", "org.apache.camel"));
        if (headers.containsKey("CamelCloudEventSubject")) {
            headers.put("ce-subject", headers.get("CamelCloudEventSubject"));
        }
        headers.put("ce-time", headers.getOrDefault("CamelCloudEventTime", CloudEvents.getEventTime(message.getExchange())));
        headers.put("Content-Type", headers.getOrDefault("Content-Type", "application/json"));
    }
}

