/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format.converter.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.kamelets.utils.format.MimeType;
import org.apache.camel.kamelets.utils.format.converter.json.Json;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="application-x-struct")
public class JsonStructDataType
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        try {
            Object unmarshalled = Json.MAPPER.reader().forType(JsonNode.class).readValue(this.getBodyAsStream(message));
            message.setBody(unmarshalled);
            message.setHeader("Content-Type", (Object)MimeType.STRUCT.type());
        }
        catch (IOException | InvalidPayloadException e) {
            throw new CamelExecutionException("Failed to apply Json input data type on exchange", message.getExchange(), e);
        }
    }

    private InputStream getBodyAsStream(Message message) throws InvalidPayloadException {
        InputStream bodyStream = (InputStream)message.getBody(InputStream.class);
        if (bodyStream == null) {
            bodyStream = new ByteArrayInputStream((byte[])message.getMandatoryBody(byte[].class));
        }
        return bodyStream;
    }
}

