/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format.converter.pojo;

import com.fasterxml.jackson.core.FormatSchema;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.kamelets.utils.format.MimeType;
import org.apache.camel.kamelets.utils.format.SchemaType;
import org.apache.camel.kamelets.utils.format.converter.avro.Avro;
import org.apache.camel.kamelets.utils.format.converter.json.Json;
import org.apache.camel.kamelets.utils.format.converter.utils.SchemaHelper;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;
import org.apache.camel.util.ObjectHelper;

@DataTypeTransformer(name="application-x-java-object")
public class JavaObjectDataType
extends Transformer
implements CamelContextAware {
    private CamelContext camelContext;

    public void transform(Message message, DataType fromType, DataType toType) {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        FormatSchema schema = (FormatSchema)message.getExchange().getProperty("X-Content-Schema", FormatSchema.class);
        if (schema == null) {
            throw new CamelExecutionException("Missing proper schema for Java object data type processing", message.getExchange());
        }
        String contentClass = SchemaHelper.resolveContentClass(message.getExchange(), null);
        if (contentClass == null) {
            throw new CamelExecutionException("Missing content class information for Java object data type processing", message.getExchange());
        }
        SchemaType schemaType = SchemaType.of((String)message.getExchange().getProperty("X-Content-Schema-Type", (Object)SchemaType.JSON.type(), String.class));
        try {
            Object unmarshalled;
            Class contentType = this.camelContext.getClassResolver().resolveMandatoryClass(contentClass);
            if (schemaType == SchemaType.AVRO) {
                unmarshalled = Avro.MAPPER.reader().forType(contentType).with(schema).readValue(this.getBodyAsStream(message));
            } else if (schemaType == SchemaType.JSON) {
                unmarshalled = Json.MAPPER.reader().forType(contentType).with(schema).readValue(this.getBodyAsStream(message));
            } else {
                throw new CamelExecutionException(String.format("Unsupported schema type '%s'", new Object[]{schemaType}), message.getExchange());
            }
            message.setBody(unmarshalled);
            message.setHeader("Content-Type", (Object)MimeType.STRUCT.type());
        }
        catch (IOException | ClassNotFoundException | InvalidPayloadException e) {
            throw new CamelExecutionException("Failed to apply Java object data type on exchange", message.getExchange(), e);
        }
    }

    private InputStream getBodyAsStream(Message message) throws InvalidPayloadException {
        InputStream bodyStream = (InputStream)message.getBody(InputStream.class);
        if (bodyStream == null) {
            bodyStream = new ByteArrayInputStream((byte[])message.getMandatoryBody(byte[].class));
        }
        return bodyStream;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }
}

