/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format.converter.utils;

import java.util.Objects;
import org.apache.camel.Exchange;

public final class PojoHelper {
    private PojoHelper() {
    }

    public static boolean isString(Class<?> type) {
        return String.class.isAssignableFrom(type);
    }

    public static boolean isNumber(Class<?> type) {
        return Number.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type);
    }

    public static boolean isPrimitive(Class<?> type) {
        return type.isPrimitive() || type.isArray() && type.getComponentType().isPrimitive() || Character.TYPE.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type) || Byte.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type);
    }

    public static boolean isPojo(Class<?> type) {
        Package pkg = type.getPackage();
        if (pkg != null && (pkg.getName().startsWith("java") || pkg.getName().startsWith("javax") || pkg.getName().startsWith("com.sun") || pkg.getName().startsWith("com.oracle"))) {
            return false;
        }
        if (PojoHelper.isNumber(type)) {
            return false;
        }
        if (PojoHelper.isPrimitive(type)) {
            return false;
        }
        return !PojoHelper.isString(type);
    }

    public static boolean hasProperty(Exchange exchange, String name) {
        return exchange.getProperties().containsKey(name);
    }

    public static boolean hasProperty(Exchange exchange, String name, Object value) {
        return Objects.equals(value, exchange.getProperty(name, value.getClass()));
    }

    public static boolean hasHeader(Exchange exchange, String name, Object value) {
        return Objects.equals(value, exchange.getMessage().getHeader(name, value.getClass()));
    }
}

