/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.transform;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Processor;

public class InsertField
implements Processor {
    String field;
    String value;

    public InsertField() {
    }

    public InsertField(String field, String value) {
        this.field = field;
        this.value = value;
    }

    public void process(Exchange ex) throws InvalidPayloadException {
        JsonNode body = (JsonNode)ex.getMessage().getBody(JsonNode.class);
        if (body == null) {
            throw new InvalidPayloadException(ex, JsonNode.class);
        }
        switch (body.getNodeType()) {
            case ARRAY: {
                ((ArrayNode)body).add(this.value);
                break;
            }
            case OBJECT: {
                ((ObjectNode)body).put(this.field, this.value);
                break;
            }
            default: {
                ((ObjectNode)body).put(this.field, this.value);
            }
        }
        ex.getMessage().setBody((Object)body);
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

