/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format.schema;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jackson.avro.transform.AvroSchemaResolver;
import org.apache.camel.component.jackson.transform.JsonSchemaResolver;
import org.apache.camel.kamelets.utils.format.MimeType;
import org.apache.camel.kamelets.utils.format.schema.protobuf.ProtobufSchemaResolver;
import org.apache.camel.util.ObjectHelper;

public class DelegatingSchemaResolver
implements Processor {
    private String mimeType;
    private String targetMimeType;
    private String schema;
    private String contentClass;

    public void process(Exchange exchange) throws Exception {
        Processor resolver;
        if (ObjectHelper.isEmpty((String)this.mimeType)) {
            return;
        }
        MimeType mimeType = MimeType.of(this.mimeType);
        if (mimeType.equals((Object)MimeType.JAVA_OBJECT)) {
            if (ObjectHelper.isEmpty((String)this.targetMimeType)) {
                return;
            }
            resolver = this.fromMimeType(MimeType.of(this.targetMimeType));
        } else {
            resolver = this.fromMimeType(mimeType);
        }
        if (resolver != null) {
            resolver.process(exchange);
        }
    }

    private Processor fromMimeType(MimeType mimeType) {
        switch (mimeType) {
            case PROTOBUF: {
                ProtobufSchemaResolver protobufSchemaResolver = new ProtobufSchemaResolver();
                protobufSchemaResolver.setSchema(this.schema);
                protobufSchemaResolver.setContentClass(this.contentClass);
                return protobufSchemaResolver;
            }
            case AVRO: 
            case AVRO_BINARY: 
            case AVRO_STRUCT: {
                AvroSchemaResolver avroSchemaResolver = new AvroSchemaResolver();
                avroSchemaResolver.setSchema(this.schema);
                avroSchemaResolver.setContentClass(this.contentClass);
                return avroSchemaResolver;
            }
            case JSON: 
            case STRUCT: {
                JsonSchemaResolver jsonSchemaResolver = new JsonSchemaResolver();
                jsonSchemaResolver.setSchema(this.schema);
                jsonSchemaResolver.setContentClass(this.contentClass);
                return jsonSchemaResolver;
            }
        }
        return null;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getContentClass() {
        return this.contentClass;
    }

    public void setContentClass(String contentClass) {
        this.contentClass = contentClass;
    }

    public String getTargetMimeType() {
        return this.targetMimeType;
    }

    public void setTargetMimeType(String targetMimeType) {
        this.targetMimeType = targetMimeType;
    }
}

