/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.common;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;

public class CxfPayload<T> {
    private List<Source> body;
    private final List<T> headers;
    private Map<String, String> nsMap;

    public CxfPayload(List<T> headers, List<Source> body, Map<String, String> nsMap) {
        this.headers = headers;
        this.body = body;
        this.nsMap = nsMap;
    }

    public CxfPayload(List<T> headers, List<Element> body) {
        this.headers = headers;
        this.body = new ArrayList<Source>(body.size());
        for (Element el : body) {
            this.body.add(new DOMSource(el));
        }
    }

    public List<Element> getBody() {
        return new AbstractList<Element>(){

            @Override
            public boolean add(Element e) {
                return CxfPayload.this.body.add(new DOMSource(e));
            }

            @Override
            public Element set(int index, Element element) {
                Source s = CxfPayload.this.body.set(index, new DOMSource(element));
                try {
                    return StaxUtils.read(s).getDocumentElement();
                }
                catch (XMLStreamException e) {
                    throw new RuntimeCamelException("Problem converting content to Element", (Throwable)e);
                }
            }

            @Override
            public void add(int index, Element element) {
                CxfPayload.this.body.add(index, new DOMSource(element));
            }

            @Override
            public Element remove(int index) {
                Source s = CxfPayload.this.body.remove(index);
                try {
                    return StaxUtils.read(s).getDocumentElement();
                }
                catch (XMLStreamException e) {
                    throw new RuntimeCamelException("Problem converting content to Element", (Throwable)e);
                }
            }

            @Override
            public Element get(int index) {
                Source s = CxfPayload.this.body.get(index);
                try {
                    Element el = StaxUtils.read(s).getDocumentElement();
                    CxfPayload.addNamespace(el, CxfPayload.this.nsMap);
                    CxfPayload.this.body.set(index, new DOMSource(el));
                    return el;
                }
                catch (Exception ex) {
                    throw new RuntimeCamelException("Problem converting content to Element", (Throwable)ex);
                }
            }

            @Override
            public int size() {
                return CxfPayload.this.body.size();
            }
        };
    }

    protected static void addNamespace(Element element, Map<String, String> nsMap) {
        if (nsMap != null) {
            for (Map.Entry<String, String> entry : nsMap.entrySet()) {
                String ns = entry.getKey();
                if ("xmlns".equals(ns)) {
                    if (!ObjectHelper.isEmpty((String)element.getAttribute("xmlns"))) continue;
                    element.setAttribute(ns, entry.getValue());
                    continue;
                }
                if (!ObjectHelper.isEmpty((String)element.getAttribute("xmlns:" + ns))) continue;
                element.setAttribute("xmlns:" + ns, entry.getValue());
            }
        }
    }

    public List<Source> getBodySources() {
        return this.body;
    }

    public void setBodySources(List<Source> body) {
        this.body = body;
    }

    public List<T> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getNsMap() {
        return this.nsMap;
    }

    public String toString() {
        return super.toString();
    }
}

