/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.transport;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.component.cxf.transport.CamelConduit;
import org.apache.camel.component.cxf.transport.CamelDestination;
import org.apache.camel.component.cxf.transport.header.CxfHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

@NoJSR250Annotations
public class CamelTransportFactory
extends AbstractTransportFactory
implements ConduitInitiator,
DestinationFactory,
CamelContextAware {
    public static final String TRANSPORT_ID = "http://cxf.apache.org/transports/camel";
    public static final List<String> DEFAULT_NAMESPACES = Arrays.asList("http://cxf.apache.org/transports/camel");
    private static final Set<String> URI_PREFIXES = new HashSet<String>();
    private HeaderFilterStrategy headerFilterStrategy;
    private boolean checkException;
    private Bus bus;
    private CamelContext camelContext;

    public CamelTransportFactory() {
        CxfHeaderFilterStrategy defaultHeaderFilterStrategy = new CxfHeaderFilterStrategy();
        defaultHeaderFilterStrategy.setOutFilterPattern("");
        this.headerFilterStrategy = defaultHeaderFilterStrategy;
    }

    public CamelTransportFactory(Bus b) {
        super(DEFAULT_NAMESPACES);
        this.bus = b;
        this.registerFactory();
        CxfHeaderFilterStrategy defaultHeaderFilterStrategy = new CxfHeaderFilterStrategy();
        defaultHeaderFilterStrategy.setOutFilterPattern("");
        this.headerFilterStrategy = defaultHeaderFilterStrategy;
    }

    public void setCheckException(boolean check) {
        this.checkException = check;
    }

    public boolean isCheckException() {
        return this.checkException;
    }

    public Conduit getConduit(EndpointInfo targetInfo) throws IOException {
        return this.getConduit(targetInfo, null, this.bus);
    }

    public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType target) throws IOException {
        return this.getConduit(endpointInfo, target, this.bus);
    }

    public Destination getDestination(EndpointInfo endpointInfo) throws IOException {
        return this.getDestination(endpointInfo, this.bus);
    }

    @Override
    public Set<String> getUriPrefixes() {
        return URI_PREFIXES;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext c) {
        this.camelContext = c;
    }

    @Override
    public Destination getDestination(EndpointInfo ei, Bus b) throws IOException {
        return new CamelDestination(this.camelContext, b, this, ei, this.headerFilterStrategy, this.checkException);
    }

    @Override
    public Conduit getConduit(EndpointInfo targetInfo, Bus b) throws IOException {
        return this.getConduit(targetInfo, null, b);
    }

    @Override
    public Conduit getConduit(EndpointInfo localInfo, EndpointReferenceType target, Bus b) throws IOException {
        return new CamelConduit(this.camelContext, b, localInfo, target, this.headerFilterStrategy);
    }

    public void setBus(Bus b) {
        this.unregisterFactory();
        this.bus = b;
        this.registerFactory();
    }

    public final void registerFactory() {
        ConduitInitiatorManager cim;
        if (null == this.bus) {
            return;
        }
        DestinationFactoryManager dfm = this.bus.getExtension(DestinationFactoryManager.class);
        if (null != dfm && this.getTransportIds() != null) {
            for (String ns : this.getTransportIds()) {
                dfm.registerDestinationFactory(ns, this);
            }
        }
        if ((cim = this.bus.getExtension(ConduitInitiatorManager.class)) != null && this.getTransportIds() != null) {
            for (String ns : this.getTransportIds()) {
                cim.registerConduitInitiator(ns, this);
            }
        }
    }

    public final void unregisterFactory() {
        ConduitInitiatorManager cim;
        if (null == this.bus) {
            return;
        }
        DestinationFactoryManager dfm = this.bus.getExtension(DestinationFactoryManager.class);
        if (null != dfm && this.getTransportIds() != null) {
            this.unregisterDestinationFactories(dfm);
        }
        if ((cim = this.bus.getExtension(ConduitInitiatorManager.class)) != null && this.getTransportIds() != null) {
            this.unregisterConduitInitiators(cim);
        }
    }

    private void unregisterConduitInitiators(ConduitInitiatorManager cim) {
        for (String ns : this.getTransportIds()) {
            try {
                if (cim.getConduitInitiator(ns) != this) continue;
                cim.deregisterConduitInitiator(ns);
            }
            catch (BusException busException) {}
        }
    }

    private void unregisterDestinationFactories(DestinationFactoryManager dfm) {
        for (String ns : this.getTransportIds()) {
            try {
                if (dfm.getDestinationFactory(ns) != this) continue;
                dfm.deregisterDestinationFactory(ns);
            }
            catch (BusException busException) {}
        }
    }

    static {
        URI_PREFIXES.add("camel://");
    }
}

