/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.transport.http.osgi;

import org.apache.camel.component.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer;
import org.apache.cxf.common.util.CollectionUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.DestinationRegistryImpl;
import org.apache.cxf.transport.http.HTTPConduitConfigurer;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class HTTPTransportActivator
implements BundleActivator {
    private static final String DISABLE_DEFAULT_HTTP_TRANSPORT = "org.apache.cxf.osgi.http.transport.disable";
    private ServiceTracker<HttpService, ?> httpServiceTracker;

    public void start(BundleContext context) throws Exception {
        ConfigAdminHttpConduitConfigurer conduitConfigurer = new ConfigAdminHttpConduitConfigurer();
        this.registerService(context, ManagedServiceFactory.class, conduitConfigurer, "org.apache.cxf.http.conduits");
        this.registerService(context, HTTPConduitConfigurer.class, conduitConfigurer, "org.apache.cxf.http.conduit-configurer");
        if (PropertyUtils.isTrue(context.getProperty(DISABLE_DEFAULT_HTTP_TRANSPORT))) {
            return;
        }
        DestinationRegistryImpl destinationRegistry = new DestinationRegistryImpl();
        HTTPTransportFactory transportFactory = new HTTPTransportFactory(destinationRegistry);
        context.registerService(DestinationRegistry.class.getName(), (Object)destinationRegistry, null);
        context.registerService(HTTPTransportFactory.class.getName(), (Object)transportFactory, null);
    }

    private <T> ServiceRegistration<T> registerService(BundleContext context, Class<T> serviceInterface, T serviceObject, String servicePid) {
        return context.registerService(serviceInterface, serviceObject, CollectionUtils.singletonDictionary("service.pid", servicePid));
    }

    public void stop(BundleContext context) throws Exception {
        if (this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
        }
    }
}

