/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.SpecExceptions;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public final class ExceptionUtils {
    private static final String PROPAGATE_EXCEPTION = "org.apache.cxf.propagate.exception";
    private static final String SUPPORT_WAE_SPEC_OPTIMIZATION = "support.wae.spec.optimization";

    private ExceptionUtils() {
    }

    public static String getStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static Class<?> getWebApplicationExceptionClass(Response exResponse, Class<?> defaultExceptionType) {
        return SpecExceptions.getWebApplicationExceptionClass(exResponse, defaultExceptionType);
    }

    public static boolean propogateException(Message m) {
        Object value = m.getContextualProperty(PROPAGATE_EXCEPTION);
        if (value == null) {
            return true;
        }
        return Boolean.TRUE.equals(value) || "true".equalsIgnoreCase(value.toString());
    }

    public static <T extends Throwable> Response convertFaultToResponse(T ex, Message currentMessage) {
        Throwable unwrappedException;
        ExceptionMapper mapper;
        WebApplicationException webEx;
        if (ex == null || currentMessage == null) {
            return null;
        }
        Message inMessage = currentMessage.getExchange().getInMessage();
        Response response = null;
        if (ex instanceof WebApplicationException && (webEx = (WebApplicationException)ex).getResponse().hasEntity() && webEx.getCause() == null && MessageUtils.getContextualBoolean(inMessage, SUPPORT_WAE_SPEC_OPTIMIZATION, true)) {
            response = webEx.getResponse();
        }
        if (response == null && (mapper = ServerProviderFactory.getInstance(inMessage).createExceptionMapper(ex.getClass(), inMessage)) != null) {
            try {
                response = mapper.toResponse(ex);
            }
            catch (Throwable mapperEx) {
                inMessage.getExchange().put("exception.from.mapper", "true");
                mapperEx.printStackTrace();
                return Response.serverError().build();
            }
        }
        if (response == null && (unwrappedException = ex.getCause()) instanceof WebApplicationException) {
            WebApplicationException webEx2 = (WebApplicationException)unwrappedException;
            response = webEx2.getResponse();
        }
        JAXRSUtils.setMessageContentType(currentMessage, response);
        return response;
    }

    public static WebApplicationException toWebApplicationException(Throwable cause, Response response) {
        return new WebApplicationException(cause, response);
    }

    public static WebApplicationException toInternalServerErrorException(Throwable cause, Response response) {
        try {
            return SpecExceptions.toInternalServerErrorException(cause, response);
        }
        catch (NoClassDefFoundError ex) {
            return ExceptionUtils.toWebApplicationException(ex, response);
        }
    }

    public static WebApplicationException toBadRequestException(Throwable cause, Response response) {
        try {
            return SpecExceptions.toBadRequestException(cause, response);
        }
        catch (NoClassDefFoundError ex) {
            return ExceptionUtils.toWebApplicationException(ex, response);
        }
    }

    public static WebApplicationException toNotFoundException(Throwable cause, Response response) {
        try {
            return SpecExceptions.toNotFoundException(cause, response);
        }
        catch (NoClassDefFoundError ex) {
            return ExceptionUtils.toWebApplicationException(ex, response);
        }
    }

    public static WebApplicationException toNotAuthorizedException(Throwable cause, Response response) {
        try {
            return SpecExceptions.toNotAuthorizedException(cause, response);
        }
        catch (NoClassDefFoundError ex) {
            return ExceptionUtils.toWebApplicationException(ex, response);
        }
    }

    public static WebApplicationException toForbiddenException(Throwable cause, Response response) {
        try {
            return SpecExceptions.toForbiddenException(cause, response);
        }
        catch (NoClassDefFoundError ex) {
            return ExceptionUtils.toWebApplicationException(ex, response);
        }
    }

    public static WebApplicationException toNotAcceptableException(Throwable cause, Response response) {
        try {
            return SpecExceptions.toNotAcceptableException(cause, response);
        }
        catch (NoClassDefFoundError ex) {
            return ExceptionUtils.toWebApplicationException(ex, response);
        }
    }

    public static WebApplicationException toNotSupportedException(Throwable cause, Response response) {
        try {
            return SpecExceptions.toNotSupportedException(cause, response);
        }
        catch (NoClassDefFoundError ex) {
            return ExceptionUtils.toWebApplicationException(ex, response);
        }
    }

    public static WebApplicationException toHttpException(Throwable cause, Response response) {
        try {
            return SpecExceptions.toHttpException(cause, response);
        }
        catch (NoClassDefFoundError ex) {
            return ExceptionUtils.toWebApplicationException(ex, response);
        }
    }

    public static WebApplicationException toWebApplicationException(Response response) {
        try {
            Class<?> exceptionClass = ExceptionUtils.getWebApplicationExceptionClass(response, WebApplicationException.class);
            Constructor<?> ctr = exceptionClass.getConstructor(Response.class);
            return (WebApplicationException)((Object)ctr.newInstance(response));
        }
        catch (Throwable ex) {
            return new WebApplicationException(response);
        }
    }
}

