/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.blueprint.jaxrs;

import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.Namespaces;
import org.apache.aries.blueprint.ParserContext;
import org.apache.camel.component.cxf.blueprint.helpers.BaseNamespaceHandler;
import org.apache.camel.component.cxf.blueprint.jaxrs.JAXRSServerFactoryBeanDefinitionParser;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.staxutils.transform.OutTransformWriter;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Namespaces(value={"http://cxf.apache.org/blueprint/jaxrs"})
public class JAXRSBPNamespaceHandler
extends BaseNamespaceHandler {
    private BlueprintContainer blueprintContainer;

    public URL getSchemaLocation(String namespace) {
        if ("http://cxf.apache.org/blueprint/jaxrs".equals(namespace) || "http://cxf.apache.org/schemas/jaxrs.xsd".equals(namespace)) {
            return this.getClass().getClassLoader().getResource("schemas/blueprint/jaxrs.xsd");
        }
        if ("http://cxf.apache.org/schemas/jaxrs-common.xsd".equals(namespace)) {
            return this.getClass().getClassLoader().getResource("schemas/blueprint/jaxrs-common.xsd");
        }
        return super.findCoreSchemaLocation(namespace);
    }

    public Metadata parse(Element element, ParserContext context) {
        String s = element.getLocalName();
        if ("server".equals(s)) {
            return new JAXRSServerFactoryBeanDefinitionParser().parse(element, context);
        }
        if ("client".equals(s)) {
            return (Metadata)context.parseElement(Metadata.class, null, this.transformElement(element));
        }
        return null;
    }

    public Set<Class> getManagedClasses() {
        return Set.of();
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        return null;
    }

    private Element transformElement(Element element) {
        Map<CallSite, String> transformMap = Collections.singletonMap("{" + element.getNamespaceURI() + "}*", "{http://cxf.apache.org/blueprint/jaxrs-client}*");
        W3CDOMStreamWriter domWriter = new W3CDOMStreamWriter();
        OutTransformWriter transformWriter = new OutTransformWriter((XMLStreamWriter)domWriter, transformMap);
        try {
            StaxUtils.copy((Element)element, (XMLStreamWriter)transformWriter);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return domWriter.getDocument().getDocumentElement();
    }

    public BlueprintContainer getBlueprintContainer() {
        return this.blueprintContainer;
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }
}

