/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.blueprint.helpers;

import java.util.HashMap;
import org.apache.camel.component.cxf.blueprint.helpers.BlueprintSupport;
import org.apache.camel.component.cxf.common.NullFaultListener;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.logging.FaultListener;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.container.BlueprintContainer;

public class RsClientBlueprintBean
extends JAXRSClientFactoryBean
implements BlueprintSupport,
Cloneable {
    private BlueprintContainer blueprintContainer;
    private BundleContext bundleContext;
    private int loggingSizeLimit;
    private LoggingFeature loggingFeature;

    @Override
    public BlueprintContainer getBlueprintContainer() {
        return this.blueprintContainer;
    }

    @Override
    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public boolean isLoggingFeatureEnabled() {
        return this.loggingFeature != null;
    }

    public void setLoggingFeatureEnabled(boolean loggingFeatureEnabled) {
        if (this.loggingFeature != null) {
            this.getFeatures().remove(this.loggingFeature);
            this.loggingFeature = null;
        }
        if (loggingFeatureEnabled) {
            this.loggingFeature = new LoggingFeature();
            if (this.getLoggingSizeLimit() > 0) {
                this.loggingFeature.setLimit(this.getLoggingSizeLimit());
            }
            this.getFeatures().add(this.loggingFeature);
        }
    }

    public int getLoggingSizeLimit() {
        return this.loggingSizeLimit;
    }

    public void setLoggingSizeLimit(int loggingSizeLimit) {
        this.loggingSizeLimit = loggingSizeLimit;
        if (this.loggingFeature != null && loggingSizeLimit > 0) {
            this.loggingFeature.setLimit(loggingSizeLimit);
        }
    }

    public void setSkipFaultLogging(boolean skipFaultLogging) {
        if (skipFaultLogging) {
            if (this.getProperties() == null) {
                this.setProperties(new HashMap());
            }
            this.getProperties().put(FaultListener.class.getName(), new NullFaultListener());
        }
    }
}

