/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.shell;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.apache.camel.karaf.shell.CamelCommandSupport;
import org.apache.camel.karaf.shell.completers.CamelContextCompleter;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="camel", name="context-start", description="Starts a Camel context")
@Service
public class ContextStart
extends CamelCommandSupport
implements Action {
    @Argument(index=0, name="context", description="The name of the Camel context", required=true, multiValued=false)
    @Completion(value=CamelContextCompleter.class)
    String name;

    public Object execute() throws Exception {
        List<CamelContext> camelContexts = this.getCamelContext(this.name);
        if (camelContexts.size() != 1) {
            System.err.println("Camel context " + this.name + " not found");
            return null;
        }
        CamelContext camelContext = camelContexts.get(0);
        if (camelContext.getStatus().equals((Object)ServiceStatus.Suspended)) {
            camelContext.resume();
        } else {
            camelContext.start();
        }
        return null;
    }
}

