/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.shell;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.karaf.shell.CamelCommandSupport;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="camel", name="context-list", description="List the Camel contexts")
@Service
public class ContextList
extends CamelCommandSupport
implements Action {
    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("Context");
        table.column("Status");
        table.column("Total #");
        table.column("Failed #");
        table.column("Inflight #");
        table.column("Uptime");
        List<CamelContext> camelContexts = this.getCamelContexts();
        for (CamelContext camelContext : camelContexts) {
            ManagedCamelContext mcc = (ManagedCamelContext)camelContext.getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
            long exchangesTotal = 0L;
            long exchangesInflight = 0L;
            long exchangesFailed = 0L;
            if (mcc != null && mcc.getManagedCamelContext() != null) {
                exchangesTotal = mcc.getManagedCamelContext().getExchangesTotal();
                exchangesInflight = mcc.getManagedCamelContext().getExchangesInflight();
                exchangesFailed = mcc.getManagedCamelContext().getExchangesFailed();
            }
            table.addRow().addContent(new Object[]{camelContext.getName(), camelContext.getStatus().name(), exchangesTotal, exchangesFailed, exchangesInflight, camelContext.getUptime()});
        }
        table.print(System.out);
        return null;
    }
}

