/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.shell;

import java.net.URLDecoder;
import org.apache.camel.CamelContext;
import org.apache.camel.karaf.shell.CamelCommandSupport;
import org.apache.camel.karaf.shell.completers.CamelContextCompleter;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.util.URISupport;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="camel", name="endpoint-stats", description="List the statistics of the Camel endpoints")
@Service
public class EndpointStats
extends CamelCommandSupport
implements Action {
    @Argument(index=0, name="context", description="The name of the Camel context (support wildcard)", required=true, multiValued=false)
    @Completion(value=CamelContextCompleter.class)
    String name;
    @Option(name="--filter", aliases={"-f"}, description="Filter the list by in, out, static, dynamic", required=false, multiValued=true)
    String[] filter;
    @Option(name="--decode", aliases={"-d"}, description="Whether to decode the endpoint uri so its human readable", required=false, multiValued=false, valueToShowInHelp="true")
    boolean decode = true;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("Context");
        table.column("Uri");
        table.column("Route Id");
        table.column("Direction");
        table.column("Static");
        table.column("Dynamic");
        table.column("Total #");
        CamelContext camelContext = this.getCamelContext(this.name);
        if (camelContext == null) {
            System.err.println("Camel context " + this.name + " not found");
            return null;
        }
        if (camelContext.getRuntimeEndpointRegistry() != null) {
            EndpointRegistry endpointRegistry = camelContext.getEndpointRegistry();
            for (RuntimeEndpointRegistry.Statistic stat : camelContext.getRuntimeEndpointRegistry().getEndpointStatistics()) {
                String uri = stat.getUri();
                String routeId = stat.getRouteId();
                String direction = stat.getDirection();
                boolean isStatic = endpointRegistry.isStatic(uri);
                boolean isDynamic = endpointRegistry.isDynamic(uri);
                long hits = stat.getHits();
                if (this.decode) {
                    uri = URLDecoder.decode(uri, "UTF-8");
                }
                uri = URISupport.sanitizeUri((String)uri);
                if (!this.isValidRow(direction, Boolean.toString(isStatic), Boolean.toString(isDynamic))) continue;
                table.addRow().addContent(new Object[]{camelContext.getName(), uri, routeId, direction, isStatic, isDynamic, hits});
            }
        }
        table.print(System.out);
        return null;
    }

    private boolean isValidRow(String direction, String isStatic, String isDynamic) {
        if (this.filter == null || this.filter.length == 0) {
            return true;
        }
        boolean answer = false;
        for (String f : this.filter) {
            if ("in".equals(f)) {
                answer = "in".equals(direction);
            } else if ("out".equals(f)) {
                answer = "out".equals(direction);
            } else if ("static".equals(f)) {
                answer = "true".equals(isStatic);
            } else if ("dynamic".equals(f)) {
                answer = "true".equals(isDynamic);
            }
            if (answer) continue;
            return false;
        }
        return answer;
    }
}

