/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.component.solr.SolrComponentVerifierExtension;
import org.apache.camel.component.solr.SolrConfiguration;
import org.apache.camel.component.solr.SolrEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.solr.client.solrj.SolrClient;

@Component(value="solr")
public class SolrComponent
extends DefaultComponent {
    @Metadata(label="advanced", autowired=true)
    private SolrClient solrClient;
    @Metadata
    private String host;
    @Metadata
    private int port;
    @Metadata
    private String defaultCollection;
    @Metadata(defaultValue="600000")
    private long requestTimeout = 600000L;
    @Metadata(defaultValue="60000")
    private long connectionTimeout = 60000L;
    @Metadata(label="security", secret=true)
    private String username;
    @Metadata(label="security", secret=true)
    private String password;
    @Metadata(label="security")
    private boolean enableSSL;

    public SolrComponent() {
        this(null);
    }

    public SolrComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new SolrComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SolrConfiguration config = new SolrConfiguration();
        config.setSolrClient(this.getSolrClient());
        config.setHost(this.getHost());
        config.setPort(this.getPort());
        config.setCollection(this.getDefaultCollection());
        config.setRequestTimeout(this.getRequestTimeout());
        config.setConnectionTimeout(this.getConnectionTimeout());
        config.setEnableSSL(this.isEnableSSL());
        config.setUsername(this.getUsername());
        config.setPassword(this.getPassword());
        config.configure(uri);
        SolrEndpoint endpoint = new SolrEndpoint(uri, this, config);
        this.setProperties((Endpoint)endpoint, parameters);
        if (config.getCollection() == null && config.getSolrClient() != null) {
            config.setCollection(config.getSolrClient().getDefaultCollection());
        }
        return endpoint;
    }

    public SolrClient getSolrClient() {
        return this.solrClient;
    }

    public void setSolrClient(SolrClient solrClient) {
        this.solrClient = solrClient;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getDefaultCollection() {
        return this.defaultCollection;
    }

    public void setDefaultCollection(String defaultCollection) {
        this.defaultCollection = defaultCollection;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isEnableSSL() {
        return this.enableSSL;
    }

    public void setEnableSSL(boolean enableSSL) {
        this.enableSSL = enableSSL;
    }
}

