/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.activemq.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import org.springframework.jms.listener.AbstractMessageListenerContainer;

@TargetClass(value=AbstractMessageListenerContainer.class)
final class SubstituteAbstractMessageListenerContainer {
    @Alias
    private String subscriptionName;
    @Alias
    private volatile String messageSelector;
    @Alias
    private boolean pubSubDomain;
    @Alias
    private boolean subscriptionDurable;
    @Alias
    private boolean pubSubNoLocal;

    SubstituteAbstractMessageListenerContainer() {
    }

    @Substitute
    protected MessageConsumer createConsumer(Session session, Destination destination) throws JMSException {
        if (this.pubSubDomain && destination instanceof Topic) {
            if (this.subscriptionDurable) {
                return session.createDurableSubscriber((Topic)destination, this.subscriptionName, this.messageSelector, this.pubSubNoLocal);
            }
            return session.createConsumer(destination, this.messageSelector, this.pubSubNoLocal);
        }
        return session.createConsumer(destination, this.messageSelector);
    }
}

