/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.activemq.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import org.springframework.jms.core.JmsTemplate;

@TargetClass(value=JmsTemplate.class)
final class SubstituteJmsTemplate {
    @Alias
    private boolean explicitQosEnabled;
    @Alias
    private int deliveryMode;
    @Alias
    private int priority;
    @Alias
    private long timeToLive;

    SubstituteJmsTemplate() {
    }

    @Substitute
    protected void doSend(MessageProducer producer, Message message) throws JMSException {
        if (this.explicitQosEnabled) {
            producer.send(message, this.deliveryMode, this.priority, this.timeToLive);
        } else {
            producer.send(message);
        }
    }
}

