/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.avro.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ObjectSubstitutionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.generic.GenericContainer;
import org.apache.camel.quarkus.component.avro.AvroDataFormatProducer;
import org.apache.camel.quarkus.component.avro.AvroRecorder;
import org.apache.camel.quarkus.component.avro.AvroSchemaSubstitution;
import org.apache.camel.quarkus.component.avro.BuildTimeAvroDataFormat;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

class AvroProcessor {
    private static final Logger LOG = Logger.getLogger(AvroProcessor.class);
    private static final String FEATURE = "camel-avro";
    private static DotName BUILD_TIME_AVRO_DATAFORMAT_ANNOTATION = DotName.createSimple((String)BuildTimeAvroDataFormat.class.getName());

    AvroProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    List<ReflectiveClassBuildItem> reflectiveClasses() {
        ArrayList<ReflectiveClassBuildItem> items = new ArrayList<ReflectiveClassBuildItem>();
        items.add(new ReflectiveClassBuildItem(false, false, new Class[]{GenericContainer.class}));
        return items;
    }

    @BuildStep
    void additionalBeanClasses(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer) {
        additionalBeanProducer.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{AvroDataFormatProducer.class}));
    }

    @BuildStep
    AnnotationsTransformerBuildItem markFieldsAnnotatedWithBuildTimeAvroDataFormatAsInjectable() {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.FIELD;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                FieldInfo fieldInfo = ctx.getTarget().asField();
                if (fieldInfo.annotation(BUILD_TIME_AVRO_DATAFORMAT_ANNOTATION) != null) {
                    ((Transformation)ctx.transform().add(Inject.class, new AnnotationValue[0])).done();
                }
            }
        });
    }

    @BuildStep
    void overrideAvroSchemasSerialization(BuildProducer<ObjectSubstitutionBuildItem> substitutions) {
        ObjectSubstitutionBuildItem.Holder holder = new ObjectSubstitutionBuildItem.Holder(Schema.class, byte[].class, AvroSchemaSubstitution.class);
        substitutions.produce((BuildItem)new ObjectSubstitutionBuildItem(holder));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void recordAvroSchemasResigtration(BeanArchiveIndexBuildItem beanArchiveIndex, BeanContainerBuildItem beanContainer, AvroRecorder avroRecorder) {
        IndexView index = beanArchiveIndex.getIndex();
        for (AnnotationInstance annotation : index.getAnnotations(BUILD_TIME_AVRO_DATAFORMAT_ANNOTATION)) {
            String schemaResourceName = annotation.value().asString();
            FieldInfo fieldInfo = annotation.target().asField();
            String injectedFieldId = fieldInfo.declaringClass().name() + "." + fieldInfo.name();
            try {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(schemaResourceName);
                try {
                    Schema avroSchema = new Schema.Parser().parse(is);
                    avroRecorder.recordAvroSchemaResigtration(beanContainer.getValue(), injectedFieldId, avroSchema);
                    LOG.debug((Object)("Parsed the avro schema at build time from resource named " + schemaResourceName));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException | SchemaParseException ex) {
                String message = "An issue occured while parsing schema resource on field " + injectedFieldId;
                throw new RuntimeException(message, ex);
            }
        }
    }
}

