/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.avro.rpc.spi;

import io.quarkus.arc.Arc;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import java.lang.annotation.Annotation;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.ResponderServlet;
import org.apache.avro.ipc.Server;
import org.apache.camel.quarkus.component.avro.rpc.spi.HttpServletRequestFromBytes;
import org.apache.camel.quarkus.component.avro.rpc.spi.HttpServletResponseWithBytes;

public class VertxHttpServer
implements Server {
    private int port;
    private ResponderServlet responder;

    public VertxHttpServer(Responder servletAvro, int port) throws Exception {
        this.port = port;
        this.responder = new ResponderServlet(servletAvro);
    }

    public int getPort() {
        return this.port;
    }

    public void start() {
        Vertx vertx = (Vertx)Arc.container().instance(Vertx.class, new Annotation[0]).get();
        vertx.createHttpServer().requestHandler(rc -> rc.bodyHandler(handler -> {
            HttpServletRequestFromBytes req = new HttpServletRequestFromBytes(handler.getBytes(), rc.method().name());
            HttpServletResponseWithBytes resp = new HttpServletResponseWithBytes();
            vertx.executeBlocking(promise -> {
                try {
                    this.responder.service((ServletRequest)req, (ServletResponse)resp);
                    promise.complete((Object)Buffer.buffer((byte[])resp.getBytes()));
                }
                catch (Exception e) {
                    promise.fail((Throwable)e);
                }
            }, false, result -> {
                if (result.succeeded()) {
                    rc.response().end((Buffer)result.result());
                } else {
                    rc.response().setStatusCode(500).end();
                }
            });
        })).listen(this.port);
    }

    public void close() {
    }

    public void join() throws InterruptedException {
        throw new AvroRuntimeException((Throwable)new UnsupportedOperationException());
    }
}

