/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.avro;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Singleton;
import org.apache.avro.Schema;
import org.apache.camel.dataformat.avro.AvroDataFormat;
import org.apache.camel.quarkus.component.avro.BuildTimeAvroDataFormat;

@Singleton
public class AvroDataFormatProducer {
    private final Map<String, Schema> schemaRegistry = new HashMap<String, Schema>();

    public void registerAvroSchema(String injectedFieldId, Schema schema) {
        this.schemaRegistry.put(injectedFieldId, schema);
    }

    @Produces
    AvroDataFormat produceAvroDataFormat(InjectionPoint injectionPoint) {
        Member member = injectionPoint.getMember();
        if (member instanceof Field) {
            Field field = (Field)member;
            if (!Modifier.isStatic(member.getModifiers()) && field.getAnnotation(BuildTimeAvroDataFormat.class) != null) {
                String injectedFieldId = member.getDeclaringClass().getName() + "." + member.getName();
                Schema schema = this.schemaRegistry.get(injectedFieldId);
                return new AvroDataFormat(schema);
            }
        }
        String message = "AvroDataFormat beans can only be injected into non-static field annotated with @";
        throw new IllegalArgumentException(message + BuildTimeAvroDataFormat.class.getName());
    }
}

