/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.avro;

import io.quarkus.runtime.ObjectSubstitution;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.avro.Schema;

public class AvroSchemaSubstitution
implements ObjectSubstitution<Schema, byte[]> {
    public byte[] serialize(Schema schema) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        try (ObjectOutputStream out = new ObjectOutputStream(baos);){
            out.writeObject(schema);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not serialize " + Schema.class.getName() + " " + schema, ex);
        }
        return baos.toByteArray();
    }

    public Schema deserialize(byte[] schemaBytes) {
        Schema schema;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(schemaBytes);
        ObjectInputStream in = new ObjectInputStream(inputStream);
        try {
            schema = (Schema)in.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException ex) {
                throw new RuntimeException("Could not deserialize " + Schema.class.getName(), ex);
            }
        }
        in.close();
        return schema;
    }
}

