/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.azure.eventhubs.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import java.util.stream.Stream;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

class AzureEventhubsProcessor {
    private static final String FEATURE = "camel-azure-eventhubs";

    AzureEventhubsProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    void reflectiveClasses(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        String[] modelClasses = (String[])combinedIndex.getIndex().getKnownClasses().stream().map(ClassInfo::name).map(DotName::toString).filter(n -> n.startsWith("com.azure.messaging.eventhubs.models.") || n.startsWith("com.azure.core.amqp.models.")).sorted().toArray(String[]::new);
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, true, modelClasses));
    }

    @BuildStep
    IndexDependencyBuildItem indexDependency() {
        return new IndexDependencyBuildItem("com.azure", "azure-messaging-eventhubs");
    }

    @BuildStep
    void nativeResources(BuildProducer<NativeImageResourceBuildItem> nativeResources) {
        nativeResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"azure-messaging-eventhubs.properties", "eventhubs-checkpointstore-blob-messages.properties", "eventhubs-messages.properties"}));
    }

    @BuildStep
    void runtimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClasses) {
        Stream.of("com.azure.messaging.eventhubs.PartitionBasedLoadBalancer", "com.microsoft.azure.proton.transport.proxy.impl.DigestProxyChallengeProcessorImpl", "com.microsoft.azure.proton.transport.ws.impl.Utils").map(RuntimeInitializedClassBuildItem::new).forEach(arg_0 -> runtimeInitializedClasses.produce(arg_0));
    }
}

