/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bean.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.apache.camel.support.language.DefaultAnnotationExpressionFactory;
import org.apache.camel.support.language.LanguageAnnotation;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BeanProcessor {
    private static final String FEATURE = "camel-bean";
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanProcessor.class);
    private static final DotName LANGUAGE_ANNOTATION = DotName.createSimple((String)LanguageAnnotation.class.getName());

    BeanProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem("org.apache.camel.bean");
    }

    @BuildStep
    void registerReflectiveClasses(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> producer) {
        IndexView view = index.getIndex();
        for (AnnotationInstance languageAnnotationInstance : view.getAnnotations(LANGUAGE_ANNOTATION)) {
            ClassInfo languageClassInfo = languageAnnotationInstance.target().asClass();
            LOGGER.debug("Found language @interface {} annotated with @LanguageAnnotation", (Object)languageClassInfo.name());
            if (view.getAnnotations(languageClassInfo.name()).isEmpty()) continue;
            LOGGER.debug("Registered {} as reflective class", (Object)languageClassInfo.name());
            producer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{languageClassInfo.name().toString()}));
            AnnotationValue languageAnnotationExpressionFactory = languageAnnotationInstance.value("factory");
            if (languageAnnotationExpressionFactory == null) {
                LOGGER.debug("Registered {} as reflective class", (Object)DefaultAnnotationExpressionFactory.class.getName());
                producer.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{DefaultAnnotationExpressionFactory.class}));
                continue;
            }
            LOGGER.debug("Registered {} as reflective class", (Object)languageAnnotationExpressionFactory.asString());
            producer.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{languageAnnotationExpressionFactory.asString()}));
        }
    }
}

